/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.task;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.nativeimpl.task.appointment.Appointment;
import org.ballerinalang.nativeimpl.task.timer.Timer;

public class TaskRegistry {
    private static TaskRegistry instance = new TaskRegistry();
    private Map<String, Timer> timers = new HashMap<String, Timer>();
    private Map<String, Appointment> appointments = new HashMap<String, Appointment>();

    private TaskRegistry() {
    }

    public static TaskRegistry getInstance() {
        return instance;
    }

    public void stopTask(String taskId) throws Exception {
        if (this.timers.containsKey(taskId)) {
            this.timers.get(taskId).stop();
        } else if (this.appointments.containsKey(taskId)) {
            this.appointments.get(taskId).stop();
        }
    }

    public void addTimer(Timer timer) {
        String taskId = timer.getId();
        this.checkDuplicateTask(taskId);
        this.timers.put(taskId, timer);
    }

    public void addAppointment(Appointment appointment) {
        String taskId = appointment.getId();
        this.checkDuplicateTask(taskId);
        this.appointments.put(taskId, appointment);
    }

    private void checkDuplicateTask(String taskId) {
        if (this.timers.containsKey(taskId) || this.appointments.containsKey(taskId)) {
            throw new IllegalArgumentException("Task with ID " + taskId + " already exists");
        }
    }

    public void remove(String taskId) {
        if (this.timers.containsKey(taskId)) {
            this.timers.remove(taskId);
        } else if (this.appointments.containsKey(taskId)) {
            this.appointments.remove(taskId);
        }
    }
}

