/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.task.appointment;

import org.ballerinalang.bre.Context;
import org.ballerinalang.nativeimpl.task.SchedulingException;
import org.ballerinalang.nativeimpl.task.TaskException;
import org.ballerinalang.nativeimpl.task.TaskIdGenerator;
import org.ballerinalang.nativeimpl.task.TaskRegistry;
import org.ballerinalang.nativeimpl.task.appointment.AppointmentJob;
import org.ballerinalang.nativeimpl.task.appointment.AppointmentManager;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.util.codegen.cpentries.FunctionRefCPEntry;
import org.quartz.SchedulerException;

public class Appointment {
    private String id = TaskIdGenerator.generate();
    private Context balParentContext;

    Appointment(AbstractNativeFunction fn, Context balParentContext, String cronExpression, FunctionRefCPEntry onTriggerFunction, FunctionRefCPEntry onErrorFunction) throws SchedulingException {
        this.balParentContext = balParentContext;
        TaskRegistry.getInstance().addAppointment(this);
        try {
            balParentContext.startTrackWorker();
            AppointmentManager.getInstance().schedule(this.id, fn, AppointmentJob.class, balParentContext, onTriggerFunction, onErrorFunction, cronExpression);
        }
        catch (SchedulerException e) {
            throw new SchedulingException(e);
        }
    }

    public String getId() {
        return this.id;
    }

    public void stop() throws TaskException {
        AppointmentManager.getInstance().stop(this.id);
        TaskRegistry.getInstance().remove(this.id);
        this.balParentContext.endTrackWorker();
    }
}

