/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.task.appointment;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.bre.Context;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.util.codegen.cpentries.FunctionRefCPEntry;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class AppointmentManager {
    private static final AppointmentManager instance = new AppointmentManager();
    private Map<String, JobKey> quartzJobs = new HashMap<String, JobKey>();
    private Scheduler scheduler;

    private AppointmentManager() {
        try {
            this.scheduler = new StdSchedulerFactory().getScheduler();
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Appointment manager creation failed", e);
        }
    }

    public static AppointmentManager getInstance() {
        return instance;
    }

    void schedule(String taskId, AbstractNativeFunction fn, Class<? extends Job> jobClass, Context balParentContext, FunctionRefCPEntry onTriggerFunction, FunctionRefCPEntry onErrorFunction, String cronExpression) throws SchedulerException {
        JobDataMap jobData = new JobDataMap();
        jobData.put("ballerina.function", (Object)fn);
        jobData.put("ballerina.parent.context", (Object)balParentContext);
        jobData.put("ballerina.onTriggerFunction", (Object)onTriggerFunction);
        jobData.put("ballerina.onErrorFunction", (Object)onErrorFunction);
        JobDetail job = JobBuilder.newJob(jobClass).usingJobData(jobData).withIdentity(taskId).build();
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(taskId).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
        this.scheduler.scheduleJob(job, (Trigger)trigger);
        this.quartzJobs.put(taskId, job.getKey());
    }

    public void stop(String taskId) {
        if (this.quartzJobs.containsKey(taskId)) {
            try {
                this.scheduler.deleteJob(this.quartzJobs.get(taskId));
            }
            catch (SchedulerException e) {
                throw new RuntimeException("Stopping appointment with ID " + taskId + " failed", e);
            }
        }
    }
}

