/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.task.timer;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.WorkerContext;
import org.ballerinalang.nativeimpl.task.SchedulingException;
import org.ballerinalang.nativeimpl.task.TaskException;
import org.ballerinalang.nativeimpl.task.TaskExecutor;
import org.ballerinalang.nativeimpl.task.TaskIdGenerator;
import org.ballerinalang.nativeimpl.task.TaskRegistry;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.cpentries.FunctionRefCPEntry;

public class Timer {
    private String id = TaskIdGenerator.generate();
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    private Context context;

    public Timer(AbstractNativeFunction fn, Context ctx, long delay, long interval, FunctionRefCPEntry onTriggerFunction, FunctionRefCPEntry onErrorFunction) throws SchedulingException {
        if (delay < 0L || interval < 0L) {
            throw new SchedulingException("Timer scheduling delay and interval should be non-negative values");
        }
        Runnable schedulerFunc = () -> Timer.callTriggerFunction(fn, ctx, onTriggerFunction, onErrorFunction);
        ctx.startTrackWorker();
        this.context = ctx;
        this.executorService.scheduleWithFixedDelay(schedulerFunc, delay, interval, TimeUnit.MILLISECONDS);
        TaskRegistry.getInstance().addTimer(this);
    }

    private static void callTriggerFunction(AbstractNativeFunction fn, Context parentCtx, FunctionRefCPEntry onTriggerFunction, FunctionRefCPEntry onErrorFunction) {
        ProgramFile programFile = parentCtx.getProgramFile();
        WorkerContext newContext = new WorkerContext(programFile, parentCtx);
        TaskExecutor.execute(fn, parentCtx, onTriggerFunction, onErrorFunction, programFile, (Context)newContext);
    }

    public String getId() {
        return this.id;
    }

    public void stop() throws TaskException {
        this.executorService.shutdown();
        TaskRegistry.getInstance().remove(this.id);
        this.context.endTrackWorker();
    }
}

