/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(packageName="ballerina.util", functionName="getHash", args={@Argument(name="baseString", type=TypeKind.STRING), @Argument(name="algorithm", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.STRING)}, isPublic=true)
public class GetHash
extends AbstractNativeFunction {
    public BValue[] execute(Context context) {
        String result;
        String algorithm;
        String baseString = this.getStringArgument(context, 0);
        switch (algorithm = this.getStringArgument(context, 1)) {
            case "SHA1": {
                algorithm = "SHA-1";
                break;
            }
            case "SHA256": {
                algorithm = "SHA-256";
                break;
            }
            case "MD5": {
                break;
            }
            default: {
                throw new BallerinaException("Unsupported algorithm " + algorithm + " for HMAC calculation");
            }
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            messageDigest.update(baseString.getBytes("UTF-8"));
            byte[] bytes = messageDigest.digest();
            char[] hexArray = "0123456789ABCDEF".toCharArray();
            char[] hexChars = new char[bytes.length * 2];
            for (int j = 0; j < bytes.length; ++j) {
                int byteVal = bytes[j] & 0xFF;
                hexChars[j * 2] = hexArray[byteVal >>> 4];
                hexChars[j * 2 + 1] = hexArray[byteVal & 0xF];
            }
            result = new String(hexChars);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BallerinaException("Error while calculating HMAC for " + algorithm + ": " + e.getMessage(), context);
        }
        catch (UnsupportedEncodingException e) {
            throw new BallerinaException("Error while encoding" + e.getMessage(), context);
        }
        return this.getBValues(new BValue[]{new BString(result)});
    }
}

