/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.util;

import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.util.HashUtils;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(packageName="ballerina.util", functionName="getHmac", args={@Argument(name="baseString", type=TypeKind.STRING), @Argument(name="keyString", type=TypeKind.STRING), @Argument(name="algorithm", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.STRING)}, isPublic=true)
public class GetHmac
extends AbstractNativeFunction {
    public BValue[] execute(Context context) {
        String result;
        String hmacAlgorithm;
        String algorithm;
        String baseString = this.getStringArgument(context, 0);
        String keyString = this.getStringArgument(context, 1);
        switch (algorithm = this.getStringArgument(context, 2)) {
            case "SHA1": {
                hmacAlgorithm = "HmacSHA1";
                break;
            }
            case "SHA256": {
                hmacAlgorithm = "HmacSHA256";
                break;
            }
            case "MD5": {
                hmacAlgorithm = "HmacMD5";
                break;
            }
            default: {
                throw new BallerinaException("Unsupported algorithm " + algorithm + " for HMAC calculation");
            }
        }
        try {
            byte[] keyBytes = keyString.getBytes(Charset.defaultCharset());
            SecretKeySpec secretKey = new SecretKeySpec(keyBytes, hmacAlgorithm);
            Mac mac = Mac.getInstance(hmacAlgorithm);
            mac.init(secretKey);
            byte[] baseStringBytes = baseString.getBytes(Charset.defaultCharset());
            result = HashUtils.toHexString(mac.doFinal(baseStringBytes));
        }
        catch (IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new BallerinaException("Error while calculating HMAC for " + hmacAlgorithm + ": " + e.getMessage(), context);
        }
        return this.getBValues(new BValue[]{new BString(result)});
    }
}

