/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.util.arrays;

import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.util.JSONUtils;
import org.ballerinalang.model.values.BBooleanArray;
import org.ballerinalang.model.values.BFloatArray;
import org.ballerinalang.model.values.BIntArray;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.util.exceptions.RuntimeErrors;

@BallerinaFunction(packageName="ballerina.util.arrays", functionName="copyOf", args={@Argument(name="anyArrayFrom", type=TypeKind.ARRAY, elementType=TypeKind.ANY), @Argument(name="anyArrayTo", type=TypeKind.ARRAY, elementType=TypeKind.ANY)}, returnType={@ReturnType(type=TypeKind.INT)}, isPublic=true)
public class AnyArrayCopyOf
extends AbstractNativeFunction {
    public BValue[] execute(Context context) {
        BValue valueFrom = this.getRefArgument(context, 0);
        BValue valueTo = this.getRefArgument(context, 1);
        if (valueFrom instanceof BJSON && valueTo instanceof BJSON) {
            BJSON jsonArrayFrom = (BJSON)valueFrom;
            BJSON jsonArrayTo = (BJSON)valueTo;
            for (int i = 0; i < jsonArrayFrom.value().size(); ++i) {
                BJSON element = JSONUtils.getArrayElement((BJSON)jsonArrayFrom, (long)i);
                JSONUtils.setArrayElement((BJSON)jsonArrayTo, (long)i, (BJSON)element);
            }
            return this.getBValues(new BValue[]{new BInteger((long)jsonArrayTo.value().size())});
        }
        BNewArray arrayFrom = (BNewArray)valueFrom;
        BNewArray arrayTo = (BNewArray)valueTo;
        if (arrayFrom instanceof BIntArray && arrayTo instanceof BIntArray) {
            BIntArray intArrayFrom = (BIntArray)arrayFrom;
            BIntArray intArrayTo = (BIntArray)arrayTo;
            int i = 0;
            while ((long)i < arrayFrom.size()) {
                intArrayTo.add((long)i, intArrayFrom.get((long)i));
                ++i;
            }
        } else if (arrayFrom instanceof BFloatArray && arrayTo instanceof BFloatArray) {
            BFloatArray floatArrayFrom = (BFloatArray)arrayFrom;
            BFloatArray floatArrayTo = (BFloatArray)arrayTo;
            int i = 0;
            while ((long)i < arrayFrom.size()) {
                floatArrayTo.add((long)i, floatArrayFrom.get((long)i));
                ++i;
            }
        } else if (arrayFrom instanceof BStringArray && arrayTo instanceof BStringArray) {
            BStringArray stringArrayFrom = (BStringArray)arrayFrom;
            BStringArray stringArrayTo = (BStringArray)arrayTo;
            int i = 0;
            while ((long)i < arrayFrom.size()) {
                stringArrayTo.add((long)i, stringArrayFrom.get((long)i));
                ++i;
            }
        } else if (arrayFrom instanceof BBooleanArray && arrayTo instanceof BBooleanArray) {
            BBooleanArray booleanArrayFrom = (BBooleanArray)arrayFrom;
            BBooleanArray booleanArrayTo = (BBooleanArray)arrayTo;
            int i = 0;
            while ((long)i < arrayFrom.size()) {
                booleanArrayTo.add((long)i, booleanArrayFrom.get((long)i));
                ++i;
            }
        } else if (arrayFrom instanceof BRefValueArray && arrayTo instanceof BRefValueArray) {
            BRefValueArray refValueArrayFrom = (BRefValueArray)arrayFrom;
            BRefValueArray refValueArrayTo = (BRefValueArray)arrayTo;
            int i = 0;
            while ((long)i < arrayFrom.size()) {
                refValueArrayTo.add((long)i, refValueArrayFrom.get((long)i));
                ++i;
            }
        } else {
            throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.ARRAY_TYPE_MISMATCH, (Object[])new Object[]{arrayFrom.getType(), arrayTo.getType()});
        }
        return this.getBValues(new BValue[]{new BInteger(arrayTo.size())});
    }
}

