/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.util.arrays;

import org.ballerinalang.bre.Context;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.util.JSONUtils;
import org.ballerinalang.model.values.BBooleanArray;
import org.ballerinalang.model.values.BFloatArray;
import org.ballerinalang.model.values.BIntArray;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.AbstractNativeFunction;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.exceptions.RuntimeErrors;

@BallerinaFunction(packageName="ballerina.util.arrays", functionName="copyOfRange", args={@Argument(name="anyArrayFrom", type=TypeKind.ARRAY, elementType=TypeKind.ANY), @Argument(name="anyArrayTo", type=TypeKind.ARRAY, elementType=TypeKind.ANY), @Argument(name="from", type=TypeKind.INT), @Argument(name="to", type=TypeKind.INT)}, returnType={@ReturnType(type=TypeKind.INT)}, isPublic=true)
public class AnyArrayRangeCopy
extends AbstractNativeFunction {
    public BValue[] execute(Context context) {
        BValue valueFrom = this.getRefArgument(context, 0);
        BValue valueTo = this.getRefArgument(context, 1);
        long fromLong = this.getIntArgument(context, 0);
        long toLong = this.getIntArgument(context, 1);
        if (toLong != (long)((int)toLong)) {
            throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.INDEX_NUMBER_TOO_LARGE, (Object[])new Object[]{toLong});
        }
        if (fromLong != (long)((int)fromLong)) {
            throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.INDEX_NUMBER_TOO_LARGE, (Object[])new Object[]{fromLong});
        }
        int from = (int)fromLong;
        int to = (int)toLong;
        if (valueFrom instanceof BJSON && valueTo instanceof BJSON) {
            BJSON jsonArrayFrom = (BJSON)valueFrom;
            BJSON jsonArrayTo = (BJSON)valueTo;
            this.checkIndexRange(jsonArrayFrom.value().size(), from, to);
            int index = 0;
            for (int i = from; i < to; ++i) {
                BJSON element = JSONUtils.getArrayElement((BJSON)jsonArrayFrom, (long)i);
                JSONUtils.setArrayElement((BJSON)jsonArrayTo, (long)index++, (BJSON)element);
            }
            return this.getBValues(new BValue[]{new BInteger((long)jsonArrayTo.value().size())});
        }
        BNewArray arrayFrom = (BNewArray)valueFrom;
        BNewArray arrayTo = (BNewArray)valueTo;
        this.checkIndexRange((int)arrayFrom.size(), from, to);
        if (arrayFrom instanceof BIntArray && arrayTo instanceof BIntArray) {
            BIntArray intArrayFrom = (BIntArray)arrayFrom;
            BIntArray intArrayTo = (BIntArray)arrayTo;
            int index = 0;
            for (int i = from; i < to; ++i) {
                intArrayTo.add((long)index++, intArrayFrom.get((long)i));
            }
        } else if (arrayFrom instanceof BFloatArray && arrayTo instanceof BFloatArray) {
            BFloatArray floatArrayFrom = (BFloatArray)arrayFrom;
            BFloatArray floatArrayTo = (BFloatArray)arrayTo;
            int index = 0;
            for (int i = from; i < to; ++i) {
                floatArrayTo.add((long)index++, floatArrayFrom.get((long)i));
            }
        } else if (arrayFrom instanceof BStringArray && arrayTo instanceof BStringArray) {
            BStringArray stringArrayFrom = (BStringArray)arrayFrom;
            BStringArray stringArrayTo = (BStringArray)arrayTo;
            int index = 0;
            for (int i = from; i < to; ++i) {
                stringArrayTo.add((long)index++, stringArrayFrom.get((long)i));
            }
        } else if (arrayFrom instanceof BBooleanArray && arrayTo instanceof BBooleanArray) {
            BBooleanArray booleanArrayFrom = (BBooleanArray)arrayFrom;
            BBooleanArray booleanArrayTo = (BBooleanArray)arrayTo;
            int index = 0;
            for (int i = from; i < to; ++i) {
                booleanArrayTo.add((long)index++, booleanArrayFrom.get((long)i));
            }
        } else if (arrayFrom instanceof BRefValueArray && arrayTo instanceof BRefValueArray) {
            BRefValueArray refValueArrayFrom = (BRefValueArray)arrayFrom;
            BRefValueArray refValueArrayTo = (BRefValueArray)arrayTo;
            int index = 0;
            for (int i = from; i < to; ++i) {
                refValueArrayTo.add((long)index++, refValueArrayFrom.get((long)i));
            }
        } else {
            throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.ARRAY_TYPE_MISMATCH, (Object[])new Object[]{arrayFrom.getType(), arrayTo.getType()});
        }
        return this.getBValues(new BValue[]{new BInteger((long)(to - from))});
    }

    private void checkIndexRange(int arraySize, int from, int to) {
        if (from < 0 || to > arraySize) {
            throw new BallerinaException("Array index out of range. Actual:" + arraySize + " requested: " + from + " to " + to);
        }
    }
}

