/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.cache.nativeimpl;

import java.util.Map;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.HandleValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.jvm.values.api.BMap;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.stdlib.cache.nativeimpl.concurrentlinkedhashmap.ConcurrentLinkedHashMap;

public class Cache {
    private static ConcurrentLinkedHashMap<String, BMap<String, Object>> cacheMap;
    private static final String MAX_CAPACITY = "capacity";
    private static final String EVICTION_FACTOR = "evictionFactor";
    private static final String EXPIRE_TIME = "expTime";
    private static final String CACHE = "CACHE";
    private static final String ID = "ID";

    private Cache() {
    }

    public static void externInit(ObjectValue cache) {
        int capacity = (int)cache.getIntValue(MAX_CAPACITY);
        cacheMap = new ConcurrentLinkedHashMap(capacity);
        cache.addNativeData(CACHE, cacheMap);
    }

    public static void externPut(ObjectValue cache, String key, BMap<String, Object> value) {
        int capacity = (int)cache.getIntValue(MAX_CAPACITY);
        float evictionFactor = (float)cache.getFloatValue(EVICTION_FACTOR);
        cacheMap = (ConcurrentLinkedHashMap)cache.getNativeData(CACHE);
        if (cacheMap.size() >= capacity) {
            int evictionKeysCount = (int)Math.ceil((float)capacity * evictionFactor);
            cacheMap.setCapacity(capacity - evictionKeysCount);
            cacheMap.setCapacity(capacity);
        }
        cacheMap.put(key, value);
    }

    public static Object externGet(ObjectValue cache, String key, Long currentTime) {
        cacheMap = (ConcurrentLinkedHashMap)cache.getNativeData(CACHE);
        BMap<String, Object> value = cacheMap.get(key);
        Long time = (Long)value.get((Object)EXPIRE_TIME);
        if (time != -1L && time <= currentTime) {
            cacheMap.remove(key);
            return null;
        }
        return value;
    }

    public static void externRemove(ObjectValue cache, String key) {
        cacheMap = (ConcurrentLinkedHashMap)cache.getNativeData(CACHE);
        cacheMap.remove(key);
    }

    public static void externRemoveAll(ObjectValue cache) {
        cacheMap = (ConcurrentLinkedHashMap)cache.getNativeData(CACHE);
        cacheMap.clear();
    }

    public static boolean externHasKey(ObjectValue cache, String key) {
        cacheMap = (ConcurrentLinkedHashMap)cache.getNativeData(CACHE);
        return cacheMap.containsKey(key);
    }

    public static BArray externKeys(ObjectValue cache) {
        cacheMap = (ConcurrentLinkedHashMap)cache.getNativeData(CACHE);
        String[] keySets = cacheMap.keySet().toArray(new String[0]);
        Object[] handleValues = new HandleValue[keySets.length];
        for (int i = 0; i < keySets.length; ++i) {
            handleValues[i] = new HandleValue((Object)keySets[i]);
        }
        return BValueCreator.createArrayValue((Object[])handleValues, (BArrayType)new BArrayType(BTypes.typeHandle));
    }

    public static int externSize(ObjectValue cache) {
        cacheMap = (ConcurrentLinkedHashMap)cache.getNativeData(CACHE);
        return cacheMap.size();
    }

    public static void externCleanUp(ObjectValue cache, Long currentTime) {
        cacheMap = (ConcurrentLinkedHashMap)cache.getNativeData(CACHE);
        for (Map.Entry<String, BMap<String, Object>> entry : cacheMap.entrySet()) {
            BMap<String, Object> value = entry.getValue();
            Long time = (Long)value.get((Object)EXPIRE_TIME);
            if (time == -1L || time > currentTime) continue;
            cacheMap.remove(entry.getKey());
        }
    }
}

