/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.cache.nativeimpl.concurrentlinkedhashmap;

import org.ballerinalang.stdlib.cache.nativeimpl.concurrentlinkedhashmap.Linked;

public class LinkedDeque<E extends Linked<E>> {
    E first = null;
    E last = null;

    private void linkLast(E e) {
        E l = this.last;
        this.last = e;
        if (l == null) {
            this.first = e;
        } else {
            l.setNext(e);
            e.setPrevious(l);
        }
    }

    E unlinkFirst() {
        E f = this.first;
        Object next = f.getNext();
        f.setNext(null);
        this.first = next;
        if (next == null) {
            this.last = null;
        } else {
            next.setPrevious(null);
        }
        return f;
    }

    private void unlink(E e) {
        Object prev = e.getPrevious();
        Object next = e.getNext();
        if (prev == null) {
            this.first = next;
        } else {
            prev.setNext(next);
            e.setPrevious(null);
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.setPrevious(prev);
            e.setNext(null);
        }
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public boolean contains(Object o) {
        return o instanceof Linked && this.contains((Linked)o);
    }

    boolean contains(Linked<?> e) {
        return e.getPrevious() != null || e.getNext() != null || e == this.first;
    }

    public void moveToBack(E e) {
        if (e != this.last) {
            this.unlink(e);
            this.linkLast(e);
        }
    }

    public boolean offerLast(E e) {
        if (this.contains((Linked<?>)e)) {
            return false;
        }
        this.linkLast(e);
        return true;
    }

    public boolean add(E e) {
        return this.offerLast(e);
    }

    public E poll() {
        return this.pollFirst();
    }

    public E pollFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.unlinkFirst();
    }

    public boolean remove(Object o) {
        if (this.contains(o)) {
            this.unlink((Linked)o);
            return true;
        }
        return false;
    }
}

