/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.cli.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.ballerinalang.BLangProgramRunner;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.ProgramFileReader;

public class ExecutorUtils {
    public static void execute(URI balxResource, boolean isFunction, String ... args) {
        ExecutorUtils.initFileSystem(balxResource);
        Path baloFilePath = Paths.get(balxResource);
        ProgramFile programFile = ExecutorUtils.readExecutableProgram(baloFilePath);
        if (isFunction) {
            BLangProgramRunner.runMain((ProgramFile)programFile, (String[])args);
        } else {
            BLangProgramRunner.runService((ProgramFile)programFile);
        }
    }

    private static void initFileSystem(URI uri) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        try {
            FileSystems.newFileSystem(uri, env);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProgramFile readExecutableProgram(Path baloFilePath) {
        ByteArrayInputStream byteIS = null;
        try {
            byteIS = new ByteArrayInputStream(Files.readAllBytes(baloFilePath));
            ProgramFileReader reader = new ProgramFileReader();
            ProgramFile programFile = reader.readProgram((InputStream)byteIS);
            return programFile;
        }
        catch (IOException iOException) {
        }
        finally {
            if (byteIS != null) {
                try {
                    byteIS.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

