/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.cli.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.ballerinalang.cli.utils.ExecutorUtils;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.spi.EmbeddedExecutor;
import org.ballerinalang.util.EmbeddedExecutorError;

public class BVMEmbeddedExecutor
implements EmbeddedExecutor {
    public Optional<EmbeddedExecutorError> executeFunction(String programArg, String functionName, String ... args) {
        URL resource;
        if (functionName == null) {
            functionName = "main";
        }
        String balxPath = programArg;
        if (programArg.contains(":")) {
            String[] programArgConstituents = programArg.split(":");
            functionName = programArgConstituents[programArgConstituents.length - 1];
            if (functionName.isEmpty() || programArg.endsWith(":")) {
                throw new BLangCompilerException("usage error: expected function name after final ':'");
            }
            balxPath = programArg.replace(":".concat(functionName), "");
        }
        if ((resource = BVMEmbeddedExecutor.class.getClassLoader().getResource("META-INF/ballerina/" + balxPath)) == null) {
            throw new BLangCompilerException("missing internal modules when executing");
        }
        try {
            URI balxResource = resource.toURI();
            BValue[] returns = ExecutorUtils.executeFunction(balxResource, functionName, args);
            if (returns.length == 1 && returns[0] instanceof BMap) {
                BMap errorRecord = (BMap)returns[0];
                return Optional.of(this.createEmbeddedExecutorError((BMap<String, BValue>)errorRecord));
            }
            return Optional.empty();
        }
        catch (URISyntaxException e) {
            throw new BLangCompilerException("error reading balx path in executor.");
        }
    }

    public void executeService(String balxPath) {
        URL resource = BVMEmbeddedExecutor.class.getClassLoader().getResource("META-INF/ballerina/" + balxPath);
        if (resource == null) {
            throw new BLangCompilerException("missing internal modules when executing");
        }
        try {
            URI balxResource = resource.toURI();
            ExecutorUtils.executeService(balxResource);
        }
        catch (URISyntaxException e) {
            throw new BLangCompilerException("error reading balx path in executor.");
        }
    }

    private EmbeddedExecutorError createEmbeddedExecutorError(BMap<String, BValue> errorRecord) {
        EmbeddedExecutorError error = new EmbeddedExecutorError();
        error.setMessage(errorRecord.get((Object)"message").stringValue());
        if (errorRecord.get((Object)"cause") != null) {
            BMap innerError = (BMap)errorRecord.get((Object)"cause");
            error.setCause(this.createEmbeddedExecutorError((BMap<String, BValue>)innerError));
        }
        return error;
    }
}

