/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.config;

import java.util.Map;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;

@BallerinaFunction(orgName="ballerina", packageName="config", functionName="get", args={@Argument(name="key", type=TypeKind.STRING), @Argument(name="vType", type=TypeKind.RECORD)})
public class GetConfig
extends BlockingNativeCallableUnit {
    private static final ConfigRegistry configRegistry = ConfigRegistry.getInstance();

    public void execute(Context context) {
        String configKey = context.getStringArgument(0);
        BString type = (BString)context.getNullableRefArgument(0);
        switch (type.stringValue()) {
            case "STRING": {
                String val = configRegistry.getAsString(configKey);
                context.setReturnValues(new BValue[]{val != null ? new BString(val) : null});
                break;
            }
            case "INT": {
                context.setReturnValues(new BValue[]{new BInteger(configRegistry.getAsInt(configKey))});
                break;
            }
            case "FLOAT": {
                context.setReturnValues(new BValue[]{new BFloat(configRegistry.getAsFloat(configKey))});
                break;
            }
            case "BOOLEAN": {
                context.setReturnValues(new BValue[]{new BBoolean(configRegistry.getAsBoolean(configKey))});
                break;
            }
            case "MAP": {
                context.setReturnValues(new BValue[]{this.buildBMap(configRegistry.getAsMap(configKey))});
                break;
            }
            default: {
                throw new IllegalStateException("invalid value type: " + type.stringValue());
            }
        }
    }

    private BMap buildBMap(Map<String, Object> section) {
        BMap map = new BMap();
        section.entrySet().forEach(entry -> {
            Object val = entry.getValue();
            if (val instanceof String) {
                map.put(entry.getKey(), (BValue)new BString((String)val));
            } else if (val instanceof Long) {
                map.put(entry.getKey(), (BValue)new BInteger(((Long)val).longValue()));
            } else if (val instanceof Double) {
                map.put(entry.getKey(), (BValue)new BFloat(((Double)val).doubleValue()));
            } else if (val instanceof Boolean) {
                map.put(entry.getKey(), (BValue)new BBoolean(((Boolean)val).booleanValue()));
            }
        });
        return map;
    }
}

