/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.config;

import java.util.Map;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.natives.annotations.BallerinaFunction;

@BallerinaFunction(orgName="ballerina", packageName="config", functionName="get")
public class GetConfig {
    private static final ConfigRegistry configRegistry = ConfigRegistry.getInstance();
    private static final String lookupErrReason = "{ballerina/config}LookupError";

    public static Object get(Strand strand, String configKey, Object type) {
        try {
            switch (type.toString()) {
                case "STRING": {
                    return configRegistry.getAsString(configKey);
                }
                case "INT": {
                    return configRegistry.getAsInt(configKey);
                }
                case "FLOAT": {
                    return configRegistry.getAsFloat(configKey);
                }
                case "BOOLEAN": {
                    return configRegistry.getAsBoolean(configKey);
                }
                case "MAP": {
                    return GetConfig.buildMapValue(configRegistry.getAsMap(configKey));
                }
            }
            throw new IllegalStateException("invalid value type: " + type.toString());
        }
        catch (IllegalArgumentException e) {
            throw BallerinaErrors.createError((String)lookupErrReason, (String)e.getMessage());
        }
    }

    private static MapValue buildMapValue(Map<String, Object> section) {
        MapValueImpl map = new MapValueImpl();
        section.forEach((arg_0, arg_1) -> GetConfig.lambda$buildMapValue$0((MapValue)map, arg_0, arg_1));
        return map;
    }

    private static /* synthetic */ void lambda$buildMapValue$0(MapValue map, String key, Object val) {
        if (val instanceof String || val instanceof Long || val instanceof Double || val instanceof Boolean) {
            map.put((Object)key, val);
        }
    }
}

