/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.config;

import java.util.List;
import java.util.Map;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.jvm.values.api.BValueCreator;

public class GetConfig {
    private static final ConfigRegistry configRegistry = ConfigRegistry.getInstance();
    public static final String LOOKUP_ERROR_REASON = "{ballerina/config}LookupError";

    public static Object get(String configKey, String type) {
        try {
            switch (type) {
                case "STRING": {
                    return configRegistry.getAsString(configKey);
                }
                case "INT": {
                    return configRegistry.getAsInt(configKey);
                }
                case "FLOAT": {
                    return configRegistry.getAsFloat(configKey);
                }
                case "BOOLEAN": {
                    return configRegistry.getAsBoolean(configKey);
                }
                case "MAP": {
                    return GetConfig.buildMapValue(configRegistry.getAsMap(configKey));
                }
                case "ARRAY": {
                    return GetConfig.buildArrayValue(configRegistry.getAsArray(configKey));
                }
            }
            throw new IllegalStateException("invalid value type: " + type);
        }
        catch (IllegalArgumentException e) {
            throw BallerinaErrors.createError((String)LOOKUP_ERROR_REASON, (String)e.getMessage());
        }
    }

    private static MapValue buildMapValue(Map<String, Object> section) {
        MapValueImpl map = new MapValueImpl();
        section.forEach((arg_0, arg_1) -> GetConfig.lambda$buildMapValue$0((MapValue)map, arg_0, arg_1));
        return map;
    }

    private static BArray buildArrayValue(List value) {
        return BValueCreator.createArrayValue((Object[])value.toArray(), (BArrayType)new BArrayType(BTypes.typeAnydata));
    }

    private static /* synthetic */ void lambda$buildMapValue$0(MapValue map, String key, Object val) {
        if (val instanceof String || val instanceof Long || val instanceof Double || val instanceof Boolean) {
            map.put((Object)key, val);
        }
    }
}

