/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.crypto.nativeimpl;

import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.crypto.util.HashUtils;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(orgName="ballerina", packageName="crypto", functionName="hmac", args={@Argument(name="baseString", type=TypeKind.STRING), @Argument(name="keyString", type=TypeKind.STRING), @Argument(name="algorithm", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.STRING)}, isPublic=true)
public class Hmac
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        String result;
        String hmacAlgorithm;
        String baseString = context.getStringArgument(0);
        String keyString = context.getStringArgument(1);
        BString algorithm = context.getNullableRefArgument(0) != null ? (BString)context.getNullableRefArgument(0) : new BString("");
        switch (algorithm.stringValue()) {
            case "SHA1": {
                hmacAlgorithm = "HmacSHA1";
                break;
            }
            case "SHA256": {
                hmacAlgorithm = "HmacSHA256";
                break;
            }
            case "MD5": {
                hmacAlgorithm = "HmacMD5";
                break;
            }
            default: {
                throw new BallerinaException("Unsupported algorithm " + algorithm + " for HMAC calculation");
            }
        }
        try {
            byte[] keyBytes = keyString.getBytes(Charset.defaultCharset());
            SecretKeySpec secretKey = new SecretKeySpec(keyBytes, hmacAlgorithm);
            Mac mac = Mac.getInstance(hmacAlgorithm);
            mac.init(secretKey);
            byte[] baseStringBytes = baseString.getBytes(Charset.defaultCharset());
            result = HashUtils.toHexString(mac.doFinal(baseStringBytes));
        }
        catch (IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new BallerinaException("Error while calculating HMAC for " + hmacAlgorithm + ": " + e.getMessage(), context);
        }
        context.setReturnValues(new BValue[]{new BString(result)});
    }
}

