/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.crypto.util;

import java.util.Formatter;

public class HashUtils {
    private HashUtils() {
    }

    public static String toHexString(byte[] bytes) {
        Formatter hexStringFormatter = new Formatter();
        for (byte b : bytes) {
            hexStringFormatter.format("%02X", b);
        }
        return hexStringFormatter.toString();
    }

    public static byte[] decodeHex(String hexString) throws IllegalArgumentException {
        char[] data = hexString.toCharArray();
        int len = data.length;
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = HashUtils.toDigit(data[j], j) << 4;
            f |= HashUtils.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    private static int toDigit(char ch, int index) throws IllegalArgumentException {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }
}

