/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.crypto.nativeimpl;

import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(orgName="ballerina", packageName="crypto", functionName="crc32", args={@Argument(name="content", type=TypeKind.ANY)}, returnType={@ReturnType(type=TypeKind.STRING)}, isPublic=true)
public class Crc32
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        byte[] bytes;
        BValue entityBody = context.getRefArgument(0);
        CRC32 checksum = new CRC32();
        BType argType = entityBody.getType();
        if (argType == BTypes.typeJSON || argType == BTypes.typeXML || argType == BTypes.typeString) {
            bytes = entityBody.stringValue().getBytes(StandardCharsets.UTF_8);
        } else if (argType.getTag() == 20 && ((BArrayType)argType).getElementType().getTag() == 2) {
            bytes = ((BValueArray)entityBody).getBytes();
        } else {
            throw new BallerinaException("failed to generate hash: unsupported data type: " + entityBody.getType().getName());
        }
        checksum.update(bytes, 0, bytes.length);
        long checksumVal = checksum.getValue();
        context.setReturnValues(new BValue[]{new BString(Long.toHexString(checksumVal))});
    }
}

