/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.crypto.nativeimpl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.crypto.CryptoUtils;

@BallerinaFunction(orgName="ballerina", packageName="crypto", functionName="decodePrivateKey", isPublic=true)
public class DecodePrivateKey {
    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static Object decodePrivateKey(Strand strand, Object keyStoreValue, String keyAlias, String keyPassword) {
        MapValue keyStore = (MapValue)keyStoreValue;
        File keyStoreFile = new File(CryptoUtils.substituteVariables(keyStore.get((Object)"path").toString()));
        try {
            Throwable throwable = null;
            try (FileInputStream fileInputStream = new FileInputStream(keyStoreFile);){
                PrivateKey privateKey;
                KeyStore keystore = KeyStore.getInstance("PKCS12");
                try {
                    keystore.load(fileInputStream, keyStore.get((Object)"password").toString().toCharArray());
                }
                catch (NoSuchAlgorithmException e) {
                    ErrorValue errorValue = CryptoUtils.createError("Keystore integrity check algorithm is not found: " + e.getMessage());
                    if (fileInputStream != null) {
                        if (throwable != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            fileInputStream.close();
                        }
                    }
                    return errorValue;
                }
                try {
                    privateKey = (PrivateKey)keystore.getKey(keyAlias, keyPassword.toCharArray());
                }
                catch (NoSuchAlgorithmException e) {
                    ErrorValue errorValue = CryptoUtils.createError("algorithm for key recovery is not found: " + e.getMessage());
                    if (fileInputStream != null) {
                        if (throwable != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            fileInputStream.close();
                        }
                    }
                    return errorValue;
                }
                catch (UnrecoverableKeyException e) {
                    ErrorValue errorValue;
                    block39: {
                        block40: {
                            errorValue = CryptoUtils.createError("key cannot be recovered: " + e.getMessage());
                            if (fileInputStream == null) break block39;
                            if (throwable == null) break block40;
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            break block39;
                        }
                        fileInputStream.close();
                    }
                    return errorValue;
                }
                if (privateKey.getAlgorithm().equals("RSA")) {
                    MapValue privateKeyRecord = BallerinaValues.createRecordValue((String)"ballerina/crypto", (String)"PrivateKey");
                    privateKeyRecord.addNativeData("NATIVE_DATA_PRIVATE_KEY", (Object)privateKey);
                    privateKeyRecord.put((Object)"algorithm", (Object)privateKey.getAlgorithm());
                    MapValue mapValue = privateKeyRecord;
                    return mapValue;
                }
                ErrorValue errorValue = CryptoUtils.createError("Not a valid RSA key");
                return errorValue;
                {
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throw throwable6;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw CryptoUtils.createError("PKCS12 key store not found at: " + keyStoreFile.getAbsoluteFile());
        }
        catch (IOException | KeyStoreException | CertificateException e) {
            throw CryptoUtils.createError("Unable to open keystore: " + e.getMessage());
        }
    }
}

