/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.crypto.nativeimpl;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.crypto.CryptoUtils;

@BallerinaFunction(orgName="ballerina", packageName="crypto", functionName="decryptRsaEcb", isPublic=true)
public class DecryptRsaEcb {
    public static Object decryptRsaEcb(Strand strand, ArrayValue inputValue, Object keys, Object padding) {
        Key key;
        byte[] input = inputValue.getBytes();
        MapValue keyMap = (MapValue)keys;
        if (keyMap.getNativeData("NATIVE_DATA_PRIVATE_KEY") != null) {
            key = (PrivateKey)keyMap.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        } else if (keyMap.getNativeData("NATIVE_DATA_PUBLIC_KEY") != null) {
            key = (PublicKey)keyMap.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        } else {
            return CryptoUtils.createError("Uninitialized private/public key");
        }
        return CryptoUtils.rsaEncryptDecrypt(CryptoUtils.CipherMode.DECRYPT, "ECB", padding.toString(), key, input, null, -1L);
    }
}

