/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.crypto.nativeimpl;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.crypto.CryptoUtils;

@BallerinaFunction(orgName="ballerina", packageName="crypto", functionName="encryptRsaEcb", isPublic=true)
public class EncryptRsaEcb {
    public static Object encryptRsaEcb(Strand strand, ArrayValue inputValue, Object keyUnion, Object padding) {
        Key key;
        byte[] input = inputValue.getBytes();
        MapValue keyMap = (MapValue)keyUnion;
        if (keyMap.getNativeData("NATIVE_DATA_PRIVATE_KEY") != null) {
            key = (PrivateKey)keyMap.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        } else if (keyMap.getNativeData("NATIVE_DATA_PUBLIC_KEY") != null) {
            key = (PublicKey)keyMap.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        } else {
            return CryptoUtils.createError("Uninitialized private/public key");
        }
        return CryptoUtils.rsaEncryptDecrypt(CryptoUtils.CipherMode.ENCRYPT, "ECB", padding.toString(), key, input, null, -1L);
    }
}

