/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.crypto.nativeimpl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.stdlib.crypto.Constants;
import org.ballerinalang.stdlib.crypto.CryptoUtils;
import org.ballerinalang.stdlib.time.util.TimeUtils;

public class Decode {
    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static Object decodePrivateKey(Object keyStoreValue, String keyAlias, String keyPassword) {
        MapValue keyStore = (MapValue)keyStoreValue;
        File keyStoreFile = new File(CryptoUtils.substituteVariables(keyStore.get((Object)"path").toString()));
        try {
            Throwable throwable = null;
            try (FileInputStream fileInputStream = new FileInputStream(keyStoreFile);){
                PrivateKey privateKey;
                KeyStore keystore = KeyStore.getInstance("PKCS12");
                try {
                    keystore.load(fileInputStream, keyStore.get((Object)"password").toString().toCharArray());
                }
                catch (NoSuchAlgorithmException e) {
                    ErrorValue errorValue = CryptoUtils.createError("Keystore integrity check algorithm is not found: " + e.getMessage());
                    if (fileInputStream != null) {
                        if (throwable != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            fileInputStream.close();
                        }
                    }
                    return errorValue;
                }
                try {
                    privateKey = (PrivateKey)keystore.getKey(keyAlias, keyPassword.toCharArray());
                }
                catch (NoSuchAlgorithmException e) {
                    ErrorValue errorValue = CryptoUtils.createError("algorithm for key recovery is not found: " + e.getMessage());
                    if (fileInputStream != null) {
                        if (throwable != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            fileInputStream.close();
                        }
                    }
                    return errorValue;
                }
                catch (UnrecoverableKeyException e) {
                    ErrorValue errorValue;
                    block39: {
                        block40: {
                            errorValue = CryptoUtils.createError("key cannot be recovered: " + e.getMessage());
                            if (fileInputStream == null) break block39;
                            if (throwable == null) break block40;
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            break block39;
                        }
                        fileInputStream.close();
                    }
                    return errorValue;
                }
                if (privateKey.getAlgorithm().equals("RSA")) {
                    MapValue privateKeyRecord = BallerinaValues.createRecordValue((BPackage)Constants.CRYPTO_PACKAGE_ID, (String)"PrivateKey");
                    privateKeyRecord.addNativeData("NATIVE_DATA_PRIVATE_KEY", (Object)privateKey);
                    privateKeyRecord.put((Object)"algorithm", (Object)privateKey.getAlgorithm());
                    MapValue mapValue = privateKeyRecord;
                    return mapValue;
                }
                ErrorValue errorValue = CryptoUtils.createError("Not a valid RSA key");
                return errorValue;
                {
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throw throwable6;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw CryptoUtils.createError("PKCS12 key store not found at: " + keyStoreFile.getAbsoluteFile());
        }
        catch (IOException | KeyStoreException | CertificateException e) {
            throw CryptoUtils.createError("Unable to open keystore: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object decodePublicKey(Object keyStoreValue, String keyAlias) {
        MapValue keyStore = (MapValue)keyStoreValue;
        File keyStoreFile = new File(CryptoUtils.substituteVariables(keyStore.get((Object)"path").toString()));
        try (FileInputStream fileInputStream = new FileInputStream(keyStoreFile);){
            PublicKey publicKey;
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            try {
                keystore.load(fileInputStream, keyStore.get((Object)"password").toString().toCharArray());
            }
            catch (NoSuchAlgorithmException e) {
                throw CryptoUtils.createError("Keystore integrity check algorithm is not found: " + e.getMessage());
            }
            Certificate certificate = keystore.getCertificate(keyAlias);
            MapValue certificateBMap = BallerinaValues.createRecordValue((BPackage)Constants.CRYPTO_PACKAGE_ID, (String)"Certificate");
            if (certificate instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)certificate;
                certificateBMap.put((Object)"issuer", (Object)x509Certificate.getIssuerX500Principal().getName());
                certificateBMap.put((Object)"subject", (Object)x509Certificate.getSubjectX500Principal().getName());
                certificateBMap.put((Object)"version0", (Object)x509Certificate.getVersion());
                certificateBMap.put((Object)"serial", (Object)x509Certificate.getSerialNumber().longValue());
                certificateBMap.put((Object)"notBefore", (Object)TimeUtils.createTimeRecord((MapValue)TimeUtils.getTimeZoneRecord(), (MapValue)TimeUtils.getTimeRecord(), (long)x509Certificate.getNotBefore().getTime(), (String)"GMT"));
                certificateBMap.put((Object)"notAfter", (Object)TimeUtils.createTimeRecord((MapValue)TimeUtils.getTimeZoneRecord(), (MapValue)TimeUtils.getTimeRecord(), (long)x509Certificate.getNotAfter().getTime(), (String)"GMT"));
                certificateBMap.put((Object)"signature", (Object)new ArrayValueImpl(x509Certificate.getSignature()));
                certificateBMap.put((Object)"signingAlgorithm", (Object)x509Certificate.getSigAlgName());
            }
            if ((publicKey = certificate.getPublicKey()).getAlgorithm().equals("RSA")) {
                MapValue publicKeyMap = BallerinaValues.createRecordValue((BPackage)Constants.CRYPTO_PACKAGE_ID, (String)"PublicKey");
                publicKeyMap.addNativeData("NATIVE_DATA_PUBLIC_KEY", (Object)publicKey);
                publicKeyMap.addNativeData("NATIVE_DATA_PUBLIC_KEY_CERTIFICATE", (Object)certificate);
                publicKeyMap.put((Object)"algorithm", (Object)publicKey.getAlgorithm());
                if (certificateBMap.size() > 0) {
                    publicKeyMap.put((Object)"certificate", (Object)certificateBMap);
                }
                MapValue mapValue = publicKeyMap;
                return mapValue;
            }
            ErrorValue errorValue = CryptoUtils.createError("Not a valid RSA key");
            return errorValue;
        }
        catch (FileNotFoundException e) {
            throw CryptoUtils.createError("PKCS12 key store not found at: " + keyStoreFile.getAbsoluteFile());
        }
        catch (IOException | KeyStoreException | CertificateException e) {
            throw CryptoUtils.createError("Unable to open keystore: " + e.getMessage());
        }
    }
}

