/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.encoding;

import java.util.Formatter;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.model.types.BErrorType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;

public class EncodingUtil {
    private EncodingUtil() {
    }

    public static String encodeHex(byte[] bytes) {
        Formatter hexStringFormatter = new Formatter();
        for (byte b : bytes) {
            hexStringFormatter.format("%02X", b);
        }
        return hexStringFormatter.toString();
    }

    public static byte[] decodeHex(String hexString) throws IllegalArgumentException {
        char[] data = hexString.toCharArray();
        int len = data.length;
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = EncodingUtil.toDigit(data[j], j) << 4;
            f |= EncodingUtil.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    private static int toDigit(char ch, int index) throws IllegalArgumentException {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static BError createEncodingError(Context context, String errMsg) {
        BMap errorRecord = BLangConnectorSPIUtil.createBStruct((Context)context, (String)"ballerina/encoding", (String)"EncodingError", (Object[])new Object[0]);
        errorRecord.put((Object)"message", (BValue)new BString(errMsg));
        return BLangVMErrors.createError((Context)context, (boolean)true, (BErrorType)BTypes.typeError, (String)"{ballerina/encoding}EncodingError", (BMap)errorRecord);
    }
}

