/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.encoding.nativeimpl;

import java.util.Base64;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.stdlib.encoding.EncodingUtil;

@BallerinaFunction(orgName="ballerina", packageName="encoding", functionName="decodeBase64", args={@Argument(name="input", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.ARRAY, elementType=TypeKind.BYTE), @ReturnType(type=TypeKind.RECORD, structType="EncodingError", structPackage="ballerina/encoding")}, isPublic=true)
public class DecodeBase64
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        String input = context.getStringArgument(0);
        try {
            byte[] output = Base64.getDecoder().decode(input);
            context.setReturnValues(new BValue[]{new BValueArray(output)});
        }
        catch (IllegalArgumentException e) {
            context.setReturnValues(new BValue[]{EncodingUtil.createEncodingError(context, "input is not a valid Base64 value")});
        }
    }
}

