package org.ballerinalang.stdlib.encoding.generated.providers;

import org.ballerinalang.annotation.JavaSPIService;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.NativeElementRepository;
import org.ballerinalang.natives.NativeElementRepository.NativeActionDef;
import org.ballerinalang.natives.NativeElementRepository.NativeFunctionDef;
import org.ballerinalang.spi.NativeElementProvider;

@JavaSPIService ("org.ballerinalang.spi.NativeElementProvider")
public class StandardNativeElementProvider implements NativeElementProvider {

	@Override
	public void populateNatives(NativeElementRepository repo) {
		repo.registerNativeFunction(new NativeFunctionDef("ballerina", "encoding", "decodeHex", new TypeKind[] { TypeKind.STRING }, new TypeKind[] { TypeKind.ARRAY, TypeKind.RECORD }, "org.ballerinalang.stdlib.encoding.nativeimpl.DecodeHex"));
		repo.registerNativeFunction(new NativeFunctionDef("ballerina", "encoding", "decodeBase64", new TypeKind[] { TypeKind.STRING }, new TypeKind[] { TypeKind.ARRAY, TypeKind.RECORD }, "org.ballerinalang.stdlib.encoding.nativeimpl.DecodeBase64"));
		repo.registerNativeFunction(new NativeFunctionDef("ballerina", "encoding", "encodeBase64", new TypeKind[] { TypeKind.ARRAY }, new TypeKind[] { TypeKind.STRING }, "org.ballerinalang.stdlib.encoding.nativeimpl.EncodeBase64"));
		repo.registerNativeFunction(new NativeFunctionDef("ballerina", "encoding", "byteArrayToString", new TypeKind[] { TypeKind.ARRAY, TypeKind.STRING }, new TypeKind[] { TypeKind.STRING }, "org.ballerinalang.stdlib.encoding.nativeimpl.ByteArrayToString"));
		repo.registerNativeFunction(new NativeFunctionDef("ballerina", "encoding", "encodeHex", new TypeKind[] { TypeKind.ARRAY }, new TypeKind[] { TypeKind.STRING }, "org.ballerinalang.stdlib.encoding.nativeimpl.EncodeHex"));
	}

}
