/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.encoding.nativeimpl;

import java.io.UnsupportedEncodingException;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(orgName="ballerina", packageName="encoding", functionName="byteArrayToString", args={@Argument(name="content", type=TypeKind.ARRAY, elementType=TypeKind.BYTE), @Argument(name="encoding", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.STRING)}, isPublic=true)
public class ByteArrayToString
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        byte[] bytes = ((BValueArray)context.getRefArgument(0)).getBytes();
        String encoding = context.getStringArgument(0);
        try {
            String value = new String(bytes, encoding);
            context.setReturnValues(new BValue[]{new BString(value)});
        }
        catch (UnsupportedEncodingException e) {
            throw new BallerinaException("unsupported encoding: " + encoding, (Throwable)e);
        }
    }
}

