/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.file.nativeimpl;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.file.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="file", functionName="copy", isPublic=true)
public class Copy {
    private static final Logger log = LoggerFactory.getLogger(Copy.class);

    public static Object copy(Strand strand, String sourcePath, String destinationPath, boolean replaceExisting) {
        Path srcPath = Paths.get(sourcePath, new String[0]);
        Path destPath = Paths.get(destinationPath, new String[0]);
        if (Files.notExists(srcPath, new LinkOption[0])) {
            return FileUtils.getBallerinaError("{ballerina/file}FileNotFoundError", "File not found: " + sourcePath);
        }
        try {
            Files.walkFileTree(srcPath, new RecursiveFileCopyVisitor(srcPath, destPath, replaceExisting));
        }
        catch (IOException ex) {
            return FileUtils.getBallerinaError("{ballerina/file}FileSystemError", ex);
        }
        return null;
    }

    static class RecursiveFileCopyVisitor
    extends SimpleFileVisitor<Path> {
        final Path source;
        final Path target;
        final boolean replaceExisting;

        RecursiveFileCopyVisitor(Path source, Path target, boolean replaceExisting) {
            this.source = source;
            this.target = target;
            this.replaceExisting = replaceExisting;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path newDirectory = this.target.resolve(this.source.relativize(dir));
            if (this.replaceExisting) {
                Files.copy(dir, newDirectory, StandardCopyOption.REPLACE_EXISTING);
            } else {
                try {
                    Files.copy(dir, newDirectory, new CopyOption[0]);
                }
                catch (FileAlreadyExistsException ioException) {
                    log.debug("Directory already exists in the path " + dir.toString() + ", Hence skipping the subtree.");
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path newFile = this.target.resolve(this.source.relativize(file));
            if (this.replaceExisting) {
                Files.copy(file, newFile, StandardCopyOption.REPLACE_EXISTING);
            } else {
                try {
                    Files.copy(file, newFile, new CopyOption[0]);
                }
                catch (FileAlreadyExistsException ioException) {
                    log.debug("File already exists in the path " + file.toString() + ", Hence skipping the subtree.");
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

