/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.file.nativeimpl;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.file.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="file", functionName="createDir", isPublic=true)
public class CreateDir {
    private static final Logger log = LoggerFactory.getLogger(CreateDir.class);

    public static Object createDir(Strand strand, String dir, boolean parentDirs) {
        try {
            Path dirPath = parentDirs ? Files.createDirectories(Paths.get(dir, new String[0]), new FileAttribute[0]) : Files.createDirectory(Paths.get(dir, new String[0]), new FileAttribute[0]);
            return dirPath.toAbsolutePath().toString();
        }
        catch (FileAlreadyExistsException e) {
            String msg = "File already exists. Failed to create the file: " + dir;
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("{ballerina/file}InvalidOperationError", msg);
        }
        catch (SecurityException e) {
            String msg = "Permission denied. Failed to create the file: " + dir;
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("{ballerina/file}PermissionError", msg);
        }
        catch (IOException e) {
            String msg = "IO error while creating the file " + dir;
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("{ballerina/file}FileSystemError", msg);
        }
        catch (Exception e) {
            String msg = "Error while creating the file " + dir;
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("{ballerina/file}FileSystemError", msg);
        }
    }
}

