/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.file.nativeimpl;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.file.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="file", functionName="createFile", isPublic=true)
public class CreateFile {
    private static final Logger log = LoggerFactory.getLogger(CreateFile.class);

    public static Object createFile(Strand strand, String path) {
        try {
            Path filepath = Files.createFile(Paths.get(path, new String[0]), new FileAttribute[0]);
            return filepath.toAbsolutePath().toString();
        }
        catch (FileAlreadyExistsException e) {
            String msg = "File already exists. Failed to create the file: " + path;
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("{ballerina/file}InvalidOperationError", msg);
        }
        catch (SecurityException e) {
            String msg = "Permission denied. Failed to create the file: " + path;
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("{ballerina/file}PermissionError", msg);
        }
        catch (NoSuchFileException e) {
            String msg = "The file does not exist in path " + path;
            return FileUtils.getBallerinaError("{ballerina/file}FileSystemError", msg);
        }
        catch (IOException e) {
            String msg = "IO error occurred while creating the file " + path;
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("{ballerina/file}FileSystemError", msg);
        }
        catch (Exception e) {
            String msg = "Error occurred while creating the file " + path;
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("{ballerina/file}FileSystemError", msg);
        }
    }
}

