/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.file.nativeimpl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.file.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="file", functionName="getFileInfo", isPublic=true)
public class GetFileInfo {
    private static final Logger log = LoggerFactory.getLogger(GetFileInfo.class);

    public static Object getFileInfo(Strand strand, String path) {
        File inputFile = Paths.get(path, new String[0]).toAbsolutePath().toFile();
        if (!inputFile.exists()) {
            return FileUtils.getBallerinaError("{ballerina/file}FileNotFoundError", "File not found: " + path);
        }
        try {
            return FileUtils.getFileInfo(inputFile);
        }
        catch (IOException e) {
            log.error("IO error while creating the file " + path, (Throwable)e);
            return FileUtils.getBallerinaError("{ballerina/file}FileSystemError", e);
        }
    }
}

