/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.file.nativeimpl;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.file.utils.FileUtils;

@BallerinaFunction(orgName="ballerina", packageName="file", functionName="readDir", isPublic=true)
public class ReadDir {
    private static BType fileInfoType;

    public static Object readDir(Strand strand, String path, long maxDepth) {
        File inputFile = Paths.get(path, new String[0]).toAbsolutePath().toFile();
        if (!inputFile.exists()) {
            return FileUtils.getBallerinaError("{ballerina/file}FileNotFoundError", "File not found: " + path);
        }
        if (!inputFile.isDirectory()) {
            return FileUtils.getBallerinaError("{ballerina/file}InvalidOperationError", "File in path " + path + " is not a directory");
        }
        if (maxDepth == -1L) {
            return ReadDir.readFileTree(inputFile, Integer.MAX_VALUE);
        }
        if (maxDepth > -1L && maxDepth < Integer.MAX_VALUE) {
            return ReadDir.readFileTree(inputFile, Math.toIntExact(maxDepth));
        }
        return FileUtils.getBallerinaError("{ballerina/file}InvalidOperationError", "Invalid maxDepth value " + maxDepth);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object readFileTree(File inputFile, int maxDepth) {
        try (Stream<Path> walk = Files.walk(inputFile.toPath(), maxDepth, new FileVisitOption[0]);){
            Object[] results = (ObjectValue[])walk.map(x -> {
                try {
                    ObjectValue objectValue = FileUtils.getFileInfo(x.toFile());
                    fileInfoType = objectValue.getType();
                    return objectValue;
                }
                catch (IOException e) {
                    throw new BallerinaException("Error while accessing file info", (Throwable)e);
                }
            }).toArray(ObjectValue[]::new);
            ArrayValue arrayValue = new ArrayValue(results, (BType)new BArrayType(fileInfoType));
            return arrayValue;
        }
        catch (IOException | BallerinaException ex) {
            return FileUtils.getBallerinaError("{ballerina/file}FileSystemError", ex);
        }
        catch (SecurityException ex) {
            return FileUtils.getBallerinaError("{ballerina/file}PermissionError", ex);
        }
    }
}

