/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.file.nativeimpl;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.file.utils.FileUtils;

@BallerinaFunction(orgName="ballerina", packageName="file", functionName="remove", isPublic=true)
public class Remove {
    private static final String CURRENT_DIR_PROPERTY_KEY = "user.dir";

    public static Object remove(Strand strand, String path, boolean recursive) {
        File removeFile = Paths.get(path, new String[0]).toAbsolutePath().toFile();
        String wdBValue = FileUtils.getSystemProperty(CURRENT_DIR_PROPERTY_KEY);
        File wd = Paths.get(wdBValue, new String[0]).toAbsolutePath().toFile();
        try {
            if (wd.getCanonicalPath().equals(removeFile.getCanonicalPath())) {
                return FileUtils.getBallerinaError("{ballerina/file}InvalidOperationError", "Cannot delete the current working directory " + wd.getCanonicalPath());
            }
            if (!removeFile.exists()) {
                return FileUtils.getBallerinaError("{ballerina/file}FileNotFoundError", "File not found: " + removeFile.getCanonicalPath());
            }
            if (recursive) {
                Path directory = Paths.get(removeFile.getCanonicalPath(), new String[0]);
                Files.walkFileTree(directory, new RecursiveFileVisitor());
            } else if (!removeFile.delete()) {
                return FileUtils.getBallerinaError("{ballerina/file}FileSystemError", "Error while deleting " + removeFile.getCanonicalPath());
            }
            return null;
        }
        catch (IOException ex) {
            return FileUtils.getBallerinaError("{ballerina/file}FileSystemError", ex);
        }
        catch (SecurityException ex) {
            return FileUtils.getBallerinaError("{ballerina/file}PermissionError", ex);
        }
    }

    static class RecursiveFileVisitor
    extends SimpleFileVisitor<Path> {
        RecursiveFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.delete(dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

