/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.file.nativeimpl;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.stdlib.file.utils.FileUtils;

@BallerinaFunction(orgName="ballerina", packageName="file", functionName="rename", isPublic=true)
public class Rename {
    public static Object rename(Strand strand, String oldPath, String newPath) {
        Path oldFilePath = Paths.get(oldPath, new String[0]);
        Path newFilePath = Paths.get(newPath, new String[0]);
        if (Files.notExists(oldFilePath, new LinkOption[0])) {
            return FileUtils.getBallerinaError("{ballerina/file}FileNotFoundError", "File not found: " + oldFilePath.toAbsolutePath());
        }
        try {
            Files.move(oldFilePath.toAbsolutePath(), newFilePath.toAbsolutePath(), new CopyOption[0]);
            return null;
        }
        catch (FileAlreadyExistsException e) {
            return FileUtils.getBallerinaError("{ballerina/file}InvalidOperationError", "File already exists in the new path " + newFilePath);
        }
        catch (IOException e) {
            return FileUtils.getBallerinaError("{ballerina/file}FileSystemError", e);
        }
        catch (SecurityException e) {
            return FileUtils.getBallerinaError("{ballerina/file}PermissionError", e);
        }
    }
}

