/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.EmptyProto;
import io.grpc.Context;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.Map;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.ParamDetail;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageConstants;
import org.ballerinalang.net.grpc.MessageHeaders;
import org.ballerinalang.net.grpc.MessageRegistry;
import org.ballerinalang.net.grpc.exception.UnsupportedFieldTypeException;
import org.ballerinalang.services.ErrorHandlerUtils;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.StructInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MessageUtils.class);
    private static final String UNKNOWN_ERROR = "Unknown Error";

    public static BStruct getHeaderStruct(Resource resource) {
        if (resource == null || resource.getParamDetails() == null) {
            throw new RuntimeException("Invalid resource input arguments");
        }
        BStruct headerStruct = null;
        for (ParamDetail detail : resource.getParamDetails()) {
            BType paramType = detail.getVarType();
            if (paramType == null || !"ballerina.grpc".equals(paramType.getPackagePath()) || !"Headers".equals(paramType.getName())) continue;
            headerStruct = BLangConnectorSPIUtil.createBStruct((ProgramFile)MessageUtils.getProgramFile(resource), (String)paramType.getPackagePath(), (String)paramType.getName(), (Object[])new Object[0]);
            break;
        }
        return headerStruct;
    }

    public static Context getContextHeader(BRefValueArray headerValues) {
        if (headerValues.size() != 0L) {
            BStruct headerValue;
            MessageHeaders metadata;
            if (headerValues.size() > 1L) {
                LOG.warn("No of Header objects found in input params:" + headerValues.size() + " , gRPC service can " + "only execute the first header object");
            }
            if ((metadata = (MessageHeaders)(headerValue = (BStruct)headerValues.getBValue(0L)).getNativeData("Metadata")) != null) {
                return Context.current().withValue(MessageHeaders.DATA_KEY, (Object)metadata);
            }
        }
        return null;
    }

    public static MessageHeaders getMessageHeaders(BRefValueArray headerValues) {
        MessageHeaders metadata = null;
        if (headerValues.size() != 0L) {
            if (headerValues.size() > 1L) {
                LOG.warn("No of Header objects found in input params:" + headerValues.size() + " , gRPC service can " + "only execute the first header object");
            }
            BStruct headerValue = (BStruct)headerValues.getBValue(0L);
            metadata = (MessageHeaders)headerValue.getNativeData("Metadata");
        }
        return metadata;
    }

    public static StreamObserver<Message> getResponseObserver(BRefType refType) {
        Object observerObject = null;
        if (refType instanceof BStruct) {
            observerObject = ((BStruct)refType).getNativeData("RESPONSE_OBSERVER");
        }
        if (observerObject instanceof StreamObserver) {
            return (StreamObserver)observerObject;
        }
        return null;
    }

    public static BStruct getConnectorError(org.ballerinalang.bre.Context context, Throwable throwable) {
        PackageInfo grpcPackageInfo = context.getProgramFile().getPackageInfo("ballerina.grpc");
        StructInfo errorStructInfo = grpcPackageInfo.getStructInfo("ConnectorError");
        return MessageUtils.getConnectorError(errorStructInfo.getType(), throwable);
    }

    public static BStruct getConnectorError(BStructType errorType, Throwable error) {
        BStruct errorStruct = new BStruct(errorType);
        if (error instanceof StatusRuntimeException) {
            StatusRuntimeException statusException = (StatusRuntimeException)error;
            int status = statusException.getStatus() != null ? statusException.getStatus().getCode().value() : -1;
            String message = statusException.getMessage();
            errorStruct.setStringField(0, message);
            errorStruct.setIntField(0, (long)status);
        } else if (error.getMessage() == null) {
            errorStruct.setStringField(0, UNKNOWN_ERROR);
        } else {
            errorStruct.setStringField(0, error.getMessage());
        }
        return errorStruct;
    }

    public static ProgramFile getProgramFile(Resource resource) {
        return resource.getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile();
    }

    static void handleFailure(StreamObserver<Message> streamObserver, BStruct error) {
        String errorMsg = error.getStringField(0);
        LOG.error(errorMsg);
        ErrorHandlerUtils.printError((String)("error: " + BLangVMErrors.getPrintableStackTrace((BStruct)error)));
        if (streamObserver != null) {
            streamObserver.onError((Throwable)new StatusRuntimeException(Status.fromCodeValue((int)Status.Code.INTERNAL.value()).withDescription(errorMsg)));
        }
    }

    static int getFieldWireType(Descriptors.FieldDescriptor.Type fieldType) {
        if (fieldType == null) {
            return -1;
        }
        Integer wireType = MessageConstants.WIRE_TYPE_MAP.get(fieldType.toProto());
        if (wireType != null) {
            return wireType;
        }
        return 2;
    }

    static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    public static Message generateProtoMessage(BValue responseValue, Descriptors.Descriptor outputType) {
        Message.Builder responseBuilder = Message.newBuilder(outputType.getName());
        int stringIndex = 0;
        int intIndex = 0;
        int floatIndex = 0;
        int boolIndex = 0;
        int refIndex = 0;
        block10: for (Descriptors.FieldDescriptor fieldDescriptor : outputType.getFields()) {
            String fieldName = fieldDescriptor.getName();
            switch (fieldDescriptor.getType().toProto().getNumber()) {
                case 1: {
                    double value = 0.0;
                    if (responseValue instanceof BStruct) {
                        value = ((BStruct)responseValue).getFloatField(floatIndex++);
                    } else if (responseValue instanceof BFloat) {
                        value = ((BFloat)responseValue).value();
                    }
                    responseBuilder.addField(fieldName, value);
                    continue block10;
                }
                case 2: {
                    float value = 0.0f;
                    if (responseValue instanceof BStruct) {
                        value = Float.parseFloat(String.valueOf(((BStruct)responseValue).getFloatField(floatIndex++)));
                    } else if (responseValue instanceof BFloat) {
                        value = Float.parseFloat(String.valueOf(((BFloat)responseValue).value()));
                    }
                    responseBuilder.addField(fieldName, Float.valueOf(value));
                    continue block10;
                }
                case 3: 
                case 4: 
                case 6: {
                    long value = 0L;
                    if (responseValue instanceof BStruct) {
                        value = ((BStruct)responseValue).getIntField(intIndex++);
                    } else if (responseValue instanceof BInteger) {
                        value = ((BInteger)responseValue).value();
                    }
                    responseBuilder.addField(fieldName, value);
                    continue block10;
                }
                case 5: 
                case 7: {
                    int value = 0;
                    if (responseValue instanceof BStruct) {
                        value = Integer.parseInt(String.valueOf(((BStruct)responseValue).getIntField(intIndex++)));
                    } else if (responseValue instanceof BInteger) {
                        value = Integer.parseInt(String.valueOf(((BInteger)responseValue).value()));
                    }
                    responseBuilder.addField(fieldName, value);
                    continue block10;
                }
                case 8: {
                    boolean value = false;
                    if (responseValue instanceof BStruct) {
                        value = ((BStruct)responseValue).getBooleanField(boolIndex++) > 0;
                    } else if (responseValue instanceof BBoolean) {
                        value = ((BBoolean)responseValue).value();
                    }
                    responseBuilder.addField(fieldName, value);
                    continue block10;
                }
                case 9: {
                    String value = null;
                    if (responseValue instanceof BStruct) {
                        value = ((BStruct)responseValue).getStringField(stringIndex++);
                    } else if (responseValue instanceof BString) {
                        value = ((BString)responseValue).value();
                    }
                    responseBuilder.addField(fieldName, value);
                    continue block10;
                }
                case 14: {
                    if (!(responseValue instanceof BStruct)) continue block10;
                    BRefType bValue = ((BStruct)responseValue).getRefField(refIndex++);
                    responseBuilder.addField(fieldName, fieldDescriptor.getEnumType().findValueByName(bValue.stringValue()));
                    continue block10;
                }
                case 11: {
                    if (!(responseValue instanceof BStruct)) continue block10;
                    BRefType bValue = ((BStruct)responseValue).getRefField(refIndex++);
                    responseBuilder.addField(fieldName, (Object)MessageUtils.generateProtoMessage((BValue)bValue, fieldDescriptor.getMessageType()));
                    continue block10;
                }
            }
            throw new UnsupportedFieldTypeException("Error while decoding request message. Field type is not supported : " + fieldDescriptor.getType());
        }
        return responseBuilder.build();
    }

    public static BValue generateRequestStruct(Message request, ProgramFile programFile, String fieldName, BType structType) {
        BStruct bValue = null;
        int stringIndex = 0;
        int intIndex = 0;
        int floatIndex = 0;
        int boolIndex = 0;
        int refIndex = 0;
        if (structType instanceof BStructType) {
            BStruct requestStruct = BLangConnectorSPIUtil.createBStruct((ProgramFile)programFile, (String)structType.getPackagePath(), (String)structType.getName(), (Object[])new Object[0]);
            block28: for (BStructType.StructField structField : ((BStructType)structType).getStructFields()) {
                String fieldType;
                String structFieldName = structField.getFieldName();
                if (structField.getFieldType() instanceof BStructType) {
                    BStructType bStructType = (BStructType)structField.getFieldType();
                    if (!MessageRegistry.getInstance().getMessageDescriptorMap().containsKey(bStructType.getName())) continue;
                    Message message = (Message)((Object)request.getFields().get(structFieldName));
                    requestStruct.setRefField(refIndex++, (BRefType)MessageUtils.generateRequestStruct(message, programFile, structFieldName, structField.getFieldType()));
                    continue;
                }
                if (!request.getFields().containsKey(structFieldName)) continue;
                switch (fieldType = structField.getFieldType().getName()) {
                    case "string": {
                        requestStruct.setStringField(stringIndex++, (String)request.getFields().get(structFieldName));
                        continue block28;
                    }
                    case "int": {
                        requestStruct.setIntField(intIndex++, ((Long)request.getFields().get(structFieldName)).longValue());
                        continue block28;
                    }
                    case "float": {
                        Number value = (Float)request.getFields().get(structFieldName);
                        if (value == null) continue block28;
                        requestStruct.setFloatField(floatIndex++, Double.parseDouble(((Float)value).toString()));
                        continue block28;
                    }
                    case "double": {
                        Number value = (Double)request.getFields().get(structFieldName);
                        if (value == null) continue block28;
                        requestStruct.setFloatField(floatIndex++, Double.parseDouble(((Double)value).toString()));
                        continue block28;
                    }
                    case "boolean": {
                        requestStruct.setBooleanField(boolIndex++, ((Integer)request.getFields().get(structFieldName)).intValue());
                        continue block28;
                    }
                    default: {
                        throw new UnsupportedFieldTypeException("Error while generating request struct. Field type is not supported : " + fieldType);
                    }
                }
            }
            bValue = requestStruct;
        } else {
            Map<String, Object> fields = request.getFields();
            if (fields.size() == 1 && fields.containsKey("value")) {
                fieldName = "value";
            }
            if (fields.containsKey(fieldName)) {
                String fieldType;
                switch (fieldType = structType.getName()) {
                    case "string": {
                        bValue = new BString((String)fields.get(fieldName));
                        break;
                    }
                    case "int": {
                        bValue = new BInteger(((Long)fields.get(fieldName)).longValue());
                        break;
                    }
                    case "float": {
                        Float value = (Float)fields.get(fieldName);
                        if (value == null) break;
                        bValue = new BFloat(Double.parseDouble(value.toString()));
                        break;
                    }
                    case "double": {
                        Double value = (Double)fields.get(fieldName);
                        if (value == null) break;
                        bValue = new BFloat(Double.parseDouble(value.toString()));
                        break;
                    }
                    case "boolean": {
                        bValue = new BBoolean(((Boolean)fields.get(fieldName)).booleanValue());
                        break;
                    }
                    default: {
                        throw new UnsupportedFieldTypeException("Error while generating request struct. Field type is not supported : " + fieldType);
                    }
                }
            }
        }
        return bValue;
    }

    public static MethodDescriptor.MethodType getMethodType(DescriptorProtos.MethodDescriptorProto methodDescriptorProto) {
        if (methodDescriptorProto.getClientStreaming() && methodDescriptorProto.getServerStreaming()) {
            return MethodDescriptor.MethodType.BIDI_STREAMING;
        }
        if (!methodDescriptorProto.getClientStreaming() && !methodDescriptorProto.getServerStreaming()) {
            return MethodDescriptor.MethodType.UNARY;
        }
        if (methodDescriptorProto.getServerStreaming()) {
            return MethodDescriptor.MethodType.SERVER_STREAMING;
        }
        if (methodDescriptorProto.getClientStreaming()) {
            return MethodDescriptor.MethodType.CLIENT_STREAMING;
        }
        return MethodDescriptor.MethodType.UNKNOWN;
    }

    public static boolean isEmptyResponse(Descriptors.Descriptor messageDescriptor) {
        if (messageDescriptor == null) {
            return false;
        }
        List descriptors = EmptyProto.getDescriptor().getMessageTypes();
        for (Descriptors.Descriptor descriptor : descriptors) {
            if (!descriptor.equals(messageDescriptor)) continue;
            return true;
        }
        return false;
    }
}

