/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageRegistry;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.exception.GrpcClientException;

public final class ServiceDefinition {
    private byte[] rootDescriptorData;
    private List<byte[]> dependentDescriptorData;
    private Descriptors.FileDescriptor fileDescriptor;

    public ServiceDefinition(byte[] rootDescriptorData, List<byte[]> depDescriptorData) {
        this.rootDescriptorData = new byte[rootDescriptorData.length];
        this.rootDescriptorData = Arrays.copyOf(rootDescriptorData, rootDescriptorData.length);
        this.dependentDescriptorData = depDescriptorData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Descriptors.FileDescriptor getDescriptor() {
        if (this.fileDescriptor != null) {
            return this.fileDescriptor;
        }
        Descriptors.FileDescriptor[] depSet = new Descriptors.FileDescriptor[this.dependentDescriptorData.size()];
        int i = 0;
        for (byte[] dis : this.dependentDescriptorData) {
            try {
                DescriptorProtos.FileDescriptorProto fileDescriptorSet = DescriptorProtos.FileDescriptorProto.parseFrom((byte[])dis);
                depSet[i] = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorSet, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
                ++i;
            }
            catch (Descriptors.DescriptorValidationException | InvalidProtocolBufferException e) {
                throw new RuntimeException("Error while gen extracting depend descriptors. ", e);
            }
        }
        try (ByteArrayInputStream targetStream = new ByteArrayInputStream(this.rootDescriptorData);){
            DescriptorProtos.FileDescriptorProto descriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom((InputStream)targetStream);
            Descriptors.FileDescriptor fileDescriptor = this.fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)descriptorProto, (Descriptors.FileDescriptor[])depSet);
            return fileDescriptor;
        }
        catch (Descriptors.DescriptorValidationException | IOException e) {
            throw new RuntimeException("Error while generating service descriptor : ", e);
        }
    }

    private Descriptors.ServiceDescriptor getServiceDescriptor() throws GrpcClientException {
        Descriptors.FileDescriptor fileDescriptor = this.getDescriptor();
        if (fileDescriptor.getFile().getServices().isEmpty()) {
            throw new GrpcClientException("No service found in proto definition file");
        }
        if (fileDescriptor.getFile().getServices().size() > 1) {
            throw new GrpcClientException("Multiple service definitions in signal proto file is not supported. Number of service found: " + fileDescriptor.getFile().getServices().size());
        }
        return (Descriptors.ServiceDescriptor)fileDescriptor.getFile().getServices().get(0);
    }

    public Map<String, MethodDescriptor<Message, Message>> getMethodDescriptors() throws GrpcClientException {
        HashMap<String, MethodDescriptor> descriptorMap = new HashMap<String, MethodDescriptor>();
        Descriptors.ServiceDescriptor serviceDescriptor = this.getServiceDescriptor();
        for (Descriptors.MethodDescriptor methodDescriptor : serviceDescriptor.getMethods()) {
            String methodName = methodDescriptor.getName();
            Descriptors.Descriptor reqMessage = methodDescriptor.getInputType();
            Descriptors.Descriptor resMessage = methodDescriptor.getOutputType();
            String fullMethodName = MethodDescriptor.generateFullMethodName((String)serviceDescriptor.getFullName(), (String)methodName);
            MethodDescriptor descriptor = MethodDescriptor.newBuilder().setType(MessageUtils.getMethodType(methodDescriptor.toProto())).setFullMethodName(fullMethodName).setRequestMarshaller(ProtoUtils.marshaller((com.google.protobuf.Message)Message.newBuilder(reqMessage.getName()).build())).setResponseMarshaller(ProtoUtils.marshaller((com.google.protobuf.Message)Message.newBuilder(resMessage.getName()).build())).setSchemaDescriptor((Object)methodDescriptor).build();
            descriptorMap.put(fullMethodName, descriptor);
            MessageRegistry messageRegistry = MessageRegistry.getInstance();
            messageRegistry.addMethodDescriptor(fullMethodName, methodDescriptor);
            messageRegistry.addMessageDescriptor(reqMessage.getName(), reqMessage);
            for (Descriptors.Descriptor nestedType : reqMessage.getNestedTypes()) {
                messageRegistry.addMessageDescriptor(nestedType.getName(), nestedType);
            }
            messageRegistry.addMessageDescriptor(resMessage.getName(), resMessage);
            for (Descriptors.Descriptor nestedType : resMessage.getNestedTypes()) {
                messageRegistry.addMessageDescriptor(nestedType.getName(), nestedType);
            }
        }
        return Collections.unmodifiableMap(descriptorMap);
    }
}

