/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder;

import com.google.protobuf.DescriptorProtos;
import io.grpc.MethodDescriptor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.builder.components.ActionBuilder;
import org.ballerinalang.net.grpc.builder.components.ClientBuilder;
import org.ballerinalang.net.grpc.builder.components.ClientStruct;
import org.ballerinalang.net.grpc.builder.components.DescriptorBuilder;
import org.ballerinalang.net.grpc.builder.components.StubBuilder;
import org.ballerinalang.net.grpc.builder.utils.BalGenConstants;
import org.ballerinalang.net.grpc.builder.utils.BalGenerationUtils;
import org.ballerinalang.net.grpc.exception.BalGenerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BallerinaFileBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(BallerinaFileBuilder.class);
    private byte[] rootDescriptor;
    private List<byte[]> dependentDescriptors;
    private String balOutPath;
    private boolean isUnaryContains = false;
    private boolean isStreamingContains = false;

    public BallerinaFileBuilder(List<byte[]> dependentDescriptors) {
        this.dependentDescriptors = dependentDescriptors;
    }

    public BallerinaFileBuilder(List<byte[]> dependentDescriptors, String balOutPath) {
        this.dependentDescriptors = dependentDescriptors;
        this.balOutPath = balOutPath;
    }

    public void build() {
        try {
            String path;
            String[] attributesNameArr;
            ByteArrayInputStream targetStream = new ByteArrayInputStream(this.rootDescriptor);
            DescriptorProtos.FileDescriptorProto fileDescriptorSet = DescriptorProtos.FileDescriptorProto.parseFrom((InputStream)targetStream);
            List messageTypeList = fileDescriptorSet.getMessageTypeList();
            List methodList = fileDescriptorSet.getService(0).getMethodList();
            List enumDescriptorProtos = fileDescriptorSet.getEnumTypeList();
            String packageName = "".equals(fileDescriptorSet.getPackage()) ? "client" : fileDescriptorSet.getPackage() + "." + "client";
            ClientBuilder clientStubBal = new ClientBuilder(fileDescriptorSet.getService(0).getName());
            String protoPackage = fileDescriptorSet.getPackage();
            DescriptorBuilder descriptorBuilder = "".equals(protoPackage) ? new DescriptorBuilder(this.dependentDescriptors, fileDescriptorSet.getName(), clientStubBal) : new DescriptorBuilder(this.dependentDescriptors, fileDescriptorSet.getPackage() + "." + fileDescriptorSet.getName(), clientStubBal);
            descriptorBuilder.setRootDescriptor(this.rootDescriptor);
            descriptorBuilder.buildMap();
            descriptorBuilder.buildKey();
            for (DescriptorProtos.MethodDescriptorProto methodDescriptorProto : methodList) {
                if (!methodDescriptorProto.getClientStreaming() && !methodDescriptorProto.getServerStreaming()) {
                    this.isUnaryContains = true;
                }
                if (!methodDescriptorProto.getClientStreaming() && !methodDescriptorProto.getServerStreaming()) continue;
                this.isStreamingContains = true;
            }
            for (DescriptorProtos.DescriptorProto descriptorProto : messageTypeList) {
                attributesNameArr = new String[descriptorProto.getFieldCount()];
                String[] attributesTypeArr = new String[descriptorProto.getFieldCount()];
                int j = 0;
                for (DescriptorProtos.FieldDescriptorProto fieldDescriptorProto : descriptorProto.getFieldList()) {
                    attributesNameArr[j] = fieldDescriptorProto.getName();
                    attributesTypeArr[j] = !fieldDescriptorProto.getTypeName().equals("") ? fieldDescriptorProto.getTypeName().split("\\.")[fieldDescriptorProto.getTypeName().split("\\.").length - 1] : BalGenerationUtils.getTypeName(fieldDescriptorProto.getType().getNumber());
                    ++j;
                }
                clientStubBal.addStruct(descriptorProto.getName(), attributesNameArr, attributesTypeArr);
            }
            for (DescriptorProtos.DescriptorProto descriptorProto : enumDescriptorProtos) {
                attributesNameArr = new String[descriptorProto.getValueCount()];
                int j = 0;
                for (DescriptorProtos.EnumValueDescriptorProto fieldDescriptorProto : descriptorProto.getValueList()) {
                    attributesNameArr[j] = fieldDescriptorProto.getName();
                    ++j;
                }
                clientStubBal.addEnum(descriptorProto.getName(), attributesNameArr);
            }
            StubBuilder.build(clientStubBal, this.isUnaryContains);
            for (DescriptorProtos.MethodDescriptorProto methodDescriptorProto : methodList) {
                MethodDescriptor.MethodType methodType = MessageUtils.getMethodType(methodDescriptorProto);
                String[] outputTypes = methodDescriptorProto.getOutputType().split("\\.");
                String typeOut = outputTypes[outputTypes.length - 1];
                String[] inputTypes = methodDescriptorProto.getInputType().split("\\.");
                String typeIn = inputTypes[inputTypes.length - 1];
                String methodName = methodDescriptorProto.getName();
                String methodID = !"".equals(fileDescriptorSet.getPackage()) ? fileDescriptorSet.getPackage() + "." + fileDescriptorSet.getService(0).getName() + BalGenConstants.FILE_SEPARATOR + methodName : fileDescriptorSet.getService(0).getName() + BalGenConstants.FILE_SEPARATOR + methodName;
                String reqMessageName = BalGenerationUtils.getMappingBalType(typeIn);
                String resMessageName = BalGenerationUtils.getMappingBalType(typeOut);
                if (("Empty".equals(reqMessageName) || "Empty".equals(resMessageName)) && !clientStubBal.isStructContains("Empty")) {
                    clientStubBal.addStruct("Empty", new String[0], new String[0]);
                }
                ActionBuilder.build(methodName, reqMessageName, resMessageName, methodID, methodType, clientStubBal);
            }
            ClientStruct sampleClient = new ClientStruct(this.isStreamingContains, this.isUnaryContains, fileDescriptorSet.getService(0).getName(), packageName);
            if (this.balOutPath == null) {
                path = this.balOutPathGenerator(packageName + "." + fileDescriptorSet.getService(0).getName());
                BalGenerationUtils.writeBallerina(clientStubBal, BalGenerationUtils.DEFAULT_SKELETON_DIR, "clientStub", path + ".pb.bal");
                BalGenerationUtils.writeBallerina(sampleClient, BalGenerationUtils.DEFAULT_SAMPLE_DIR, "sample", path + ".sample.client.bal");
            } else {
                path = this.balOutPath + BalGenConstants.FILE_SEPARATOR + fileDescriptorSet.getService(0).getName();
                BalGenerationUtils.writeBallerina(clientStubBal, BalGenerationUtils.DEFAULT_SKELETON_DIR, "clientStub", path + ".pb.bal");
                File sampleFile = new File(path + ".sample.client.bal");
                if (!sampleFile.isFile()) {
                    Files.createFile(Paths.get(sampleFile.getAbsolutePath(), new String[0]), new FileAttribute[0]);
                }
                BalGenerationUtils.writeBallerina(sampleClient, BalGenerationUtils.DEFAULT_SAMPLE_DIR, "sample", path + ".sample.client.bal");
            }
        }
        catch (IOException e) {
            throw new BalGenerationException("Error while generating .bal file.", e);
        }
    }

    private String balOutPathGenerator(String packageName) throws IOException {
        String pathString = packageName.replace(".", BalGenConstants.FILE_SEPARATOR);
        File stubFile = new File(pathString + ".pb.bal");
        File sampleFile = new File(pathString + ".sample.client.bal");
        Path path = Paths.get(stubFile.getAbsolutePath(), new String[0]).getParent();
        if (path != null) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        if (!stubFile.isFile()) {
            Files.createFile(Paths.get(stubFile.getAbsolutePath(), new String[0]), new FileAttribute[0]);
        }
        if (!sampleFile.isFile()) {
            Files.createFile(Paths.get(sampleFile.getAbsolutePath(), new String[0]), new FileAttribute[0]);
        }
        return pathString;
    }

    public void setRootDescriptor(byte[] rootDescriptor) {
        this.rootDescriptor = new byte[rootDescriptor.length];
        this.rootDescriptor = Arrays.copyOf(rootDescriptor, rootDescriptor.length);
    }
}

