/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.components;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.net.grpc.builder.components.ClientObject;
import org.ballerinalang.net.grpc.builder.components.Descriptor;
import org.ballerinalang.net.grpc.builder.components.Enum;
import org.ballerinalang.net.grpc.builder.components.Struct;
import org.ballerinalang.net.grpc.builder.components.Stub;
import org.ballerinalang.net.grpc.builder.components.StubFunctionBuilder;
import org.ballerinalang.net.grpc.builder.components.StubObject;
import org.ballerinalang.net.grpc.exception.GrpcServerValidationException;

public class ClientBuilder {
    private String rootDescriptorKey;
    private List<Struct> structs = new ArrayList<Struct>();
    private List<Enum> enums = new ArrayList<Enum>();
    private List<StubObject> stubObject = new ArrayList<StubObject>();
    private StubObject stubObjectBlocking;
    private StubObject stubObjectNonBlocking;
    private List<Descriptor> descriptors = new ArrayList<Descriptor>();
    private List<StubFunctionBuilder> stubFunctions = new ArrayList<StubFunctionBuilder>();
    private List<ClientObject> client = new ArrayList<ClientObject>();
    private ClientObject clientBlocking;
    private ClientObject clientNonBlocking;
    private String connectorId;

    public ClientBuilder(String connectorId) {
        this.connectorId = connectorId;
    }

    public void addStubFunctionBuilder(String stubTypeName) {
        StubFunctionBuilder stubFunctionsObj = new StubFunctionBuilder(this.connectorId, stubTypeName);
        this.stubFunctions.add(stubFunctionsObj);
    }

    public void addStruct(String structId, String[] attributesNameArr, String[] attributesTypeArr) {
        Struct structObj = new Struct(structId);
        for (int i = 0; i < attributesNameArr.length; ++i) {
            structObj.addAttribute(attributesNameArr[i], attributesTypeArr[i]);
        }
        this.structs.add(structObj);
    }

    public boolean isStructContains(String structId) {
        for (Struct struct : this.structs) {
            if (!structId.equals(struct.getStructId())) continue;
            return true;
        }
        return false;
    }

    public void addEnum(String enumId, String[] attributesNameArr) {
        Enum enumObj = new Enum(enumId);
        for (int i = 0; i < attributesNameArr.length; ++i) {
            String anAttributesNameArr = attributesNameArr[i];
            if (i < attributesNameArr.length - 1) {
                enumObj.addAttribute(anAttributesNameArr, ",");
                continue;
            }
            enumObj.addAttribute(anAttributesNameArr, null);
        }
        this.enums.add(enumObj);
    }

    public void addStubObjects(String stubTypeName, String stubType) {
        Stub stubObject = new Stub(this.connectorId, stubTypeName, stubType);
        if ("blocking".equals(stubType)) {
            if (this.clientBlocking == null) {
                this.clientBlocking = new ClientObject(this.connectorId);
                this.clientBlocking.setStubType("Blocking");
                this.client.add(this.clientBlocking);
            }
            this.clientBlocking.addStubObjects(stubObject);
        } else {
            if (this.clientNonBlocking == null) {
                this.clientNonBlocking = new ClientObject(this.connectorId);
                this.client.add(this.clientNonBlocking);
            }
            this.clientNonBlocking.addStubObjects(stubObject);
        }
    }

    public void addStub(String stubTypeName, String stubType) {
        if ("blocking".equals(stubType)) {
            if (this.stubObjectBlocking == null) {
                this.stubObjectBlocking = new StubObject(this.connectorId);
                this.stubObjectBlocking.setStubType("Blocking");
                this.stubObject.add(this.stubObjectBlocking);
            }
            this.stubObjectBlocking.addStub(stubTypeName, stubType);
        } else if ("non-blocking".equals(stubType)) {
            if (this.stubObjectNonBlocking == null) {
                this.stubObjectNonBlocking = new StubObject(this.connectorId);
                this.stubObject.add(this.stubObjectNonBlocking);
            }
            this.stubObjectNonBlocking.addStub(stubTypeName, stubType);
        } else {
            throw new GrpcServerValidationException("invalid stub type '" + stubType + "'.");
        }
    }

    public void addBlockingFunction(String operationId, String inputDataType, String outputDataType, String methodId) {
        if (this.stubObjectBlocking != null) {
            this.stubObjectBlocking.addBlockingFunction(operationId, inputDataType, outputDataType, methodId);
        }
    }

    public void addNonBlockingFunction(String operationId, String inputDataType, String methodId) {
        if (this.stubObjectNonBlocking != null) {
            this.stubObjectNonBlocking.addNonBlockingFunction(operationId, inputDataType, methodId);
        }
    }

    public void addStreamingFunction(String operationId, String inputDataType, String methodId) {
        if (this.stubObjectNonBlocking != null) {
            this.stubObjectNonBlocking.addStreamingFunction(operationId, inputDataType, methodId);
        }
    }

    public boolean isFunctionsStreamingNotEmpty() {
        return this.stubObjectNonBlocking != null && this.stubObjectNonBlocking.isFunctionsStreamingNotEmpty();
    }

    public void addDescriptor(Descriptor descriptor) {
        this.descriptors.add(descriptor);
    }

    public List<Struct> getStructs() {
        return this.structs;
    }

    public void setStructs(List<Struct> structs) {
        this.structs = structs;
    }

    public String getRootDescriptorKey() {
        return this.rootDescriptorKey;
    }

    public void setRootDescriptorKey(String rootDescriptorKey) {
        this.rootDescriptorKey = rootDescriptorKey;
    }

    public List<Descriptor> getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(List<Descriptor> descriptors) {
        this.descriptors = descriptors;
    }

    public List<StubFunctionBuilder> getStubFunctionBuilder() {
        return this.stubFunctions;
    }

    public void setStubFunctionBuilder(List<StubFunctionBuilder> stubFunctions) {
        this.stubFunctions = stubFunctions;
    }
}

