/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.listener;

import com.google.protobuf.Descriptors;
import io.grpc.stub.StreamObserver;
import java.util.List;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.Executor;
import org.ballerinalang.connector.api.ParamDetail;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.net.grpc.GrpcCallableUnitCallBack;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageHeaders;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.util.codegen.ProgramFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MethodListener {
    private Descriptors.MethodDescriptor methodDescriptor;
    private static final Logger LOG = LoggerFactory.getLogger(MethodListener.class);

    MethodListener(Descriptors.MethodDescriptor methodDescriptor) {
        this.methodDescriptor = methodDescriptor;
    }

    private BValue getConnectionParameter(Resource resource, StreamObserver<Message> responseObserver) {
        ProgramFile programFile = MessageUtils.getProgramFile(resource);
        BStruct clientEndpoint = BLangConnectorSPIUtil.createBStruct((ProgramFile)programFile, (String)"ballerina.grpc", (String)"ClientResponder", (Object[])new Object[0]);
        clientEndpoint.setIntField(0, (long)responseObserver.hashCode());
        clientEndpoint.addNativeData("RESPONSE_OBSERVER", responseObserver);
        clientEndpoint.addNativeData("RESPONSE_DEFINITION", (Object)this.methodDescriptor.getOutputType());
        BStruct endpoint = BLangConnectorSPIUtil.createBStruct((ProgramFile)programFile, (String)"ballerina.grpc", (String)"Service", (Object[])new Object[0]);
        endpoint.setRefField(0, (BRefType)clientEndpoint);
        return endpoint;
    }

    private BValue getRequestParameter(Resource resource, Message requestMessage, boolean isHeaderRequired) {
        if (resource == null || resource.getParamDetails() == null || resource.getParamDetails().size() > 3) {
            throw new RuntimeException("Invalid resource input arguments. arguments must not be greater than three");
        }
        List paramDetails = resource.getParamDetails();
        if (isHeaderRequired && paramDetails.size() == 3 || !isHeaderRequired && paramDetails.size() == 2) {
            BType requestType = ((ParamDetail)paramDetails.get(1)).getVarType();
            String requestName = ((ParamDetail)paramDetails.get(1)).getVarName();
            return MessageUtils.generateRequestStruct(requestMessage, MessageUtils.getProgramFile(resource), requestName, requestType);
        }
        return null;
    }

    boolean isEmptyResponse() {
        return this.methodDescriptor != null && MessageUtils.isEmptyResponse(this.methodDescriptor.getOutputType());
    }

    void onErrorInvoke(Resource resource, StreamObserver<Message> responseObserver, Throwable t) {
        if (resource == null) {
            String message = "Error in listener service definition. onError resource does not exists";
            LOG.error(message);
            throw new RuntimeException(message);
        }
        List paramDetails = resource.getParamDetails();
        BValue[] signatureParams = new BValue[paramDetails.size()];
        signatureParams[0] = this.getConnectionParameter(resource, responseObserver);
        BType errorType = ((ParamDetail)paramDetails.get(1)).getVarType();
        BStruct errorStruct = MessageUtils.getConnectorError((BStructType)errorType, t);
        signatureParams[1] = errorStruct;
        BStruct headerStruct = MessageUtils.getHeaderStruct(resource);
        if (headerStruct != null && MessageHeaders.isPresent()) {
            MessageHeaders context = MessageHeaders.current();
            headerStruct.addNativeData("Metadata", (Object)new MessageHeaders(context));
        }
        if (headerStruct != null && signatureParams.length == 3) {
            signatureParams[2] = headerStruct;
        }
        GrpcCallableUnitCallBack callback = new GrpcCallableUnitCallBack(responseObserver, Boolean.FALSE);
        Executor.submit((Resource)resource, (CallableUnitCallback)callback, null, null, (BValue[])signatureParams);
    }

    void onMessageInvoke(Resource resource, Message request, StreamObserver<Message> responseObserver) {
        GrpcCallableUnitCallBack callback = new GrpcCallableUnitCallBack(responseObserver, this.isEmptyResponse());
        Executor.submit((Resource)resource, (CallableUnitCallback)callback, null, null, (BValue[])this.computeMessageParams(resource, request, responseObserver));
    }

    BValue[] computeMessageParams(Resource resource, Message request, StreamObserver<Message> responseObserver) {
        BValue requestParam;
        List paramDetails = resource.getParamDetails();
        BValue[] signatureParams = new BValue[paramDetails.size()];
        signatureParams[0] = this.getConnectionParameter(resource, responseObserver);
        BStruct headerStruct = MessageUtils.getHeaderStruct(resource);
        if (headerStruct != null && MessageHeaders.isPresent()) {
            MessageHeaders context = MessageHeaders.current();
            headerStruct.addNativeData("Metadata", (Object)new MessageHeaders(context));
        }
        if ((requestParam = this.getRequestParameter(resource, request, headerStruct != null)) != null) {
            signatureParams[1] = requestParam;
        }
        if (headerStruct != null) {
            signatureParams[signatureParams.length - 1] = headerStruct;
        }
        return signatureParams;
    }
}

