/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.clientendpoint;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.config.EndpointConfiguration;
import org.ballerinalang.net.grpc.nativeimpl.EndpointUtils;
import org.ballerinalang.net.grpc.ssl.SSLHandlerFactory;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="initEndpoint", receiver=@Receiver(type=TypeKind.STRUCT, structType="Client", structPackage="ballerina.grpc"), args={@Argument(name="config", type=TypeKind.STRUCT, structType="ClientEndpointConfig")}, isPublic=true)
public class InitEndpoint
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        try {
            ManagedChannel channel;
            Struct clientEndpoint = BLangConnectorSPIUtil.getConnectorEndpointStruct((Context)context);
            Struct endpointConfig = clientEndpoint.getStructField("config");
            EndpointConfiguration configuration = EndpointUtils.getEndpointConfiguration(endpointConfig);
            if (configuration.getSslConfig() == null) {
                channel = ManagedChannelBuilder.forAddress((String)configuration.getHost(), (int)configuration.getPort()).usePlaintext(true).build();
            } else {
                SslContext sslContext = new SSLHandlerFactory(configuration.getSslConfig()).createHttp2TLSContextForClient();
                channel = ((NettyChannelBuilder)NettyChannelBuilder.forAddress((SocketAddress)InitEndpoint.generateSocketAddress(configuration.getHost(), configuration.getPort())).flowControlWindow(66560).maxInboundMessageSize(0x1000000)).sslContext(sslContext).build();
            }
            clientEndpoint.addNativeData("channel", (Object)channel);
        }
        catch (Throwable throwable) {
            BStruct errorStruct = MessageUtils.getConnectorError(context, throwable);
            context.setError(errorStruct);
        }
    }

    private static InetSocketAddress generateSocketAddress(String host, int port) {
        try {
            InetAddress inetAddress = InetAddress.getByName("localhost");
            inetAddress = InetAddress.getByAddress(host, inetAddress.getAddress());
            return new InetSocketAddress(inetAddress, port);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

