/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.connection.client;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.grpc.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="complete", receiver=@Receiver(type=TypeKind.STRUCT, structType="ClientConnection", structPackage="ballerina.grpc"), returnType={@ReturnType(type=TypeKind.STRUCT, structType="ConnectorError", structPackage="ballerina.grpc")}, isPublic=true)
public class Complete
extends BlockingNativeCallableUnit {
    private static final Logger LOG = LoggerFactory.getLogger(Complete.class);

    public void execute(Context context) {
        BStruct connectionStruct = (BStruct)context.getRefArgument(0);
        StreamObserver requestSender = (StreamObserver)connectionStruct.getNativeData("REQUEST_SENDER");
        if (requestSender == null) {
            context.setError(MessageUtils.getConnectorError(context, (Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.INTERNAL.getCode()).withDescription("Error while initializing connector. response sender does not exist"))));
        } else {
            try {
                requestSender.onCompleted();
            }
            catch (Throwable e) {
                LOG.error("Error while sending client response.", e);
                context.setError(MessageUtils.getConnectorError(context, e));
            }
        }
    }
}

