/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.proto.definition;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.StructProto;
import java.util.List;
import org.ballerinalang.net.grpc.exception.GrpcServerException;
import org.ballerinalang.net.grpc.proto.definition.Message;
import org.ballerinalang.net.grpc.proto.definition.MessageKind;

public class StructMessage
extends Message {
    private Descriptors.Descriptor descriptor;

    private StructMessage(Descriptors.Descriptor descriptor) {
        this.descriptor = descriptor;
        this.messageName = descriptor.getFullName();
    }

    public DescriptorProtos.DescriptorProto getDescriptorProto() {
        if (this.descriptor != null) {
            return this.descriptor.toProto();
        }
        return null;
    }

    public static Builder newBuilder(String messageName) throws GrpcServerException {
        return new Builder(messageName);
    }

    @Override
    public MessageKind getMessageKind() {
        return MessageKind.STRUCT;
    }

    @Override
    public String getDependency() {
        return "google/protobuf/struct.proto";
    }

    public static class Builder {
        private String messageName;

        public Message build() throws GrpcServerException {
            Descriptors.Descriptor descriptor = this.getDescriptor();
            return new StructMessage(descriptor);
        }

        private Builder(String messageName) throws GrpcServerException {
            if (messageName == null) {
                throw new GrpcServerException("Error while initializing the builder, message name cannot be null");
            }
            this.messageName = messageName;
        }

        public Descriptors.Descriptor getDescriptor() throws GrpcServerException {
            List descriptors = StructProto.getDescriptor().getMessageTypes();
            for (Descriptors.Descriptor descriptor : descriptors) {
                if (!this.messageName.equals(descriptor.getName())) continue;
                return descriptor;
            }
            throw new GrpcServerException("Error while deriving message definition. Cannot find descriptor for the message name: " + this.messageName);
        }
    }
}

