/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.proto.definition;

import com.google.protobuf.DescriptorProtos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.net.grpc.exception.GrpcServerException;
import org.ballerinalang.net.grpc.proto.definition.Field;
import org.ballerinalang.net.grpc.proto.definition.Message;
import org.ballerinalang.net.grpc.proto.definition.MessageKind;
import org.ballerinalang.net.grpc.proto.definition.UserDefinedEnumMessage;

public class UserDefinedMessage
extends Message {
    List<Field> fieldList = new ArrayList<Field>();
    private List<UserDefinedMessage> nestedMsgList = new ArrayList<UserDefinedMessage>();
    private List<UserDefinedEnumMessage> nestedEnumList = new ArrayList<UserDefinedEnumMessage>();
    private DescriptorProtos.DescriptorProto descriptorProto;

    public DescriptorProtos.DescriptorProto getDescriptorProto() {
        return this.descriptorProto;
    }

    @Override
    public MessageKind getMessageKind() {
        return MessageKind.USER_DEFINED;
    }

    private UserDefinedMessage(DescriptorProtos.DescriptorProto descriptorProto) {
        this.descriptorProto = descriptorProto;
        this.messageName = descriptorProto.getName();
    }

    public static Builder newBuilder(String messageType) throws GrpcServerException {
        if (messageType == null) {
            throw new GrpcServerException("Error while initializing the builder, message type cannot be null");
        }
        String name = messageType.contains(":") ? messageType.replace(':', '.') : messageType;
        return new Builder(name);
    }

    @Override
    public String getMessageDefinition() {
        StringBuilder msgDefinition = new StringBuilder();
        msgDefinition.append("message ").append(this.messageName).append(" {\n");
        for (Field field : this.fieldList) {
            msgDefinition.append("\t").append(field.getFieldDefinition());
        }
        msgDefinition.append("}\n");
        return msgDefinition.toString();
    }

    @Override
    public List<UserDefinedMessage> getNestedMessageList() {
        return Collections.unmodifiableList(this.nestedMsgList);
    }

    @Override
    public List<UserDefinedEnumMessage> getNestedEnumList() {
        return Collections.unmodifiableList(this.nestedEnumList);
    }

    public static class Builder {
        private DescriptorProtos.DescriptorProto.Builder messageDescriptorBuilder;
        private List<Field> fieldList = new ArrayList<Field>();
        private List<UserDefinedMessage> nestedMsgList = new ArrayList<UserDefinedMessage>();
        private List<UserDefinedEnumMessage> nestedEnumList = new ArrayList<UserDefinedEnumMessage>();

        public Message build() {
            UserDefinedMessage message = new UserDefinedMessage(this.messageDescriptorBuilder.build());
            message.fieldList = this.fieldList;
            message.nestedEnumList = this.nestedEnumList;
            message.nestedMsgList = this.nestedMsgList;
            return message;
        }

        private Builder(String messageName) {
            this.messageDescriptorBuilder = DescriptorProtos.DescriptorProto.newBuilder();
            this.messageDescriptorBuilder.setName(messageName);
        }

        public void addMessageDefinition(Message messageDefinition) {
            if (messageDefinition instanceof UserDefinedEnumMessage) {
                UserDefinedEnumMessage enumMessage = (UserDefinedEnumMessage)messageDefinition;
                this.messageDescriptorBuilder.addEnumType(enumMessage.getDescriptorProto());
                this.nestedEnumList.add(enumMessage);
            } else if (messageDefinition instanceof UserDefinedMessage) {
                UserDefinedMessage message = (UserDefinedMessage)messageDefinition;
                this.messageDescriptorBuilder.addNestedType(message.getDescriptorProto());
                this.nestedMsgList.add(message);
            }
        }

        public void addFieldDefinition(Field fieldDefinition) {
            this.fieldList.add(fieldDefinition);
            this.messageDescriptorBuilder.addField(fieldDefinition.getFieldDescriptorProto());
        }
    }
}

