/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.EmptyProto;
import io.grpc.Context;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.Map;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.ParamDetail;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BBooleanArray;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BFloatArray;
import org.ballerinalang.model.values.BIntArray;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.net.grpc.GrpcConstants;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageHeaders;
import org.ballerinalang.net.grpc.MessageRegistry;
import org.ballerinalang.net.grpc.exception.UnsupportedFieldTypeException;
import org.ballerinalang.services.ErrorHandlerUtils;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.StructInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MessageUtils.class);
    private static final String UNKNOWN_ERROR = "Unknown Error";

    public static BStruct getHeaderStruct(Resource resource) {
        if (resource == null || resource.getParamDetails() == null) {
            throw new RuntimeException("Invalid resource input arguments");
        }
        BStruct headerStruct = null;
        for (ParamDetail detail : resource.getParamDetails()) {
            BType paramType = detail.getVarType();
            if (paramType == null || !"ballerina.grpc".equals(paramType.getPackagePath()) || !"Headers".equals(paramType.getName())) continue;
            headerStruct = BLangConnectorSPIUtil.createBStruct((ProgramFile)MessageUtils.getProgramFile(resource), (String)paramType.getPackagePath(), (String)paramType.getName(), (Object[])new Object[0]);
            break;
        }
        return headerStruct;
    }

    public static Context getContextHeader(BRefValueArray headerValues) {
        if (headerValues.size() != 0L) {
            BStruct headerValue;
            MessageHeaders metadata;
            if (headerValues.size() > 1L) {
                LOG.warn("No of Header objects found in input params:" + headerValues.size() + " , gRPC service can " + "only execute the first header object");
            }
            if ((metadata = (MessageHeaders)(headerValue = (BStruct)headerValues.getBValue(0L)).getNativeData("Metadata")) != null) {
                return Context.current().withValue(MessageHeaders.DATA_KEY, (Object)metadata);
            }
        }
        return null;
    }

    public static MessageHeaders getMessageHeaders(BRefValueArray headerValues) {
        MessageHeaders metadata = null;
        if (headerValues.size() != 0L) {
            if (headerValues.size() > 1L) {
                LOG.warn("No of Header objects found in input params:" + headerValues.size() + " , gRPC service can " + "only execute the first header object");
            }
            BStruct headerValue = (BStruct)headerValues.getBValue(0L);
            metadata = (MessageHeaders)headerValue.getNativeData("Metadata");
        }
        return metadata;
    }

    public static StreamObserver<Message> getResponseObserver(BRefType refType) {
        Object observerObject = null;
        if (refType instanceof BStruct) {
            observerObject = ((BStruct)refType).getNativeData("RESPONSE_OBSERVER");
        }
        if (observerObject instanceof StreamObserver) {
            return (StreamObserver)observerObject;
        }
        return null;
    }

    public static BStruct getConnectorError(org.ballerinalang.bre.Context context, Throwable throwable) {
        ProgramFile progFile = context.getProgramFile();
        PackageInfo errorPackageInfo = progFile.getPackageInfo("ballerina.builtin");
        StructInfo errorStructInfo = errorPackageInfo.getStructInfo("error");
        return MessageUtils.getConnectorError(errorStructInfo.getType(), throwable);
    }

    public static BStruct getConnectorError(BStructType errorType, Throwable error) {
        BStruct errorStruct = new BStruct(errorType);
        if (error instanceof StatusRuntimeException) {
            StatusRuntimeException statusException = (StatusRuntimeException)error;
            String status = statusException.getStatus() != null ? statusException.getStatus().toString() : "";
            String message = status + statusException.getMessage();
            errorStruct.setStringField(0, message);
        } else if (error.getMessage() == null) {
            errorStruct.setStringField(0, UNKNOWN_ERROR);
        } else {
            errorStruct.setStringField(0, error.getMessage());
        }
        return errorStruct;
    }

    public static ProgramFile getProgramFile(Resource resource) {
        return resource.getResourceInfo().getServiceInfo().getPackageInfo().getProgramFile();
    }

    static void handleFailure(StreamObserver<Message> streamObserver, BStruct error) {
        String errorMsg = error.getStringField(0);
        LOG.error(errorMsg);
        ErrorHandlerUtils.printError((String)("error: " + BLangVMErrors.getPrintableStackTrace((BStruct)error)));
        if (streamObserver != null) {
            streamObserver.onError((Throwable)new StatusRuntimeException(Status.fromCodeValue((int)Status.Code.INTERNAL.value()).withDescription(errorMsg)));
        }
    }

    static int getFieldWireType(Descriptors.FieldDescriptor.Type fieldType) {
        if (fieldType == null) {
            return -1;
        }
        Integer wireType = GrpcConstants.WIRE_TYPE_MAP.get(fieldType.toProto());
        if (wireType != null) {
            return wireType;
        }
        return 2;
    }

    public static void setNestedMessages(Descriptors.Descriptor resMessage, MessageRegistry messageRegistry) {
        for (Descriptors.Descriptor nestedType : resMessage.getNestedTypes()) {
            messageRegistry.addMessageDescriptor(nestedType.getName(), nestedType);
        }
        for (Descriptors.FieldDescriptor msgField : resMessage.getFields()) {
            if (!Descriptors.FieldDescriptor.Type.MESSAGE.equals((Object)msgField.getType())) continue;
            Descriptors.Descriptor msgType = msgField.getMessageType();
            messageRegistry.addMessageDescriptor(msgType.getName(), msgType);
        }
    }

    static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    public static Message generateProtoMessage(BValue responseValue, Descriptors.Descriptor outputType) {
        Message.Builder responseBuilder = Message.newBuilder(outputType.getName());
        int stringIndex = 0;
        int intIndex = 0;
        int floatIndex = 0;
        int boolIndex = 0;
        int refIndex = 0;
        block10: for (Descriptors.FieldDescriptor fieldDescriptor : outputType.getFields()) {
            String fieldName = fieldDescriptor.getName();
            switch (fieldDescriptor.getType().toProto().getNumber()) {
                case 1: {
                    int i;
                    BRefType bValue;
                    double value = 0.0;
                    if (responseValue instanceof BStruct) {
                        if (fieldDescriptor.isRepeated()) {
                            bValue = ((BStruct)responseValue).getRefField(refIndex++);
                            BFloatArray valueArray = (BFloatArray)bValue;
                            Double[] messages = new Double[(int)valueArray.size()];
                            i = 0;
                            while ((long)i < valueArray.size()) {
                                double indexValue = valueArray.get((long)i);
                                messages[i] = indexValue;
                                ++i;
                            }
                            responseBuilder.addField(fieldName, messages);
                            break;
                        }
                        value = ((BStruct)responseValue).getFloatField(floatIndex++);
                        responseBuilder.addField(fieldName, value);
                        break;
                    }
                    if (responseValue instanceof BFloat) {
                        value = ((BFloat)responseValue).value();
                    }
                    responseBuilder.addField(fieldName, value);
                    break;
                }
                case 2: {
                    BFloatArray valueArray;
                    BRefType bValue;
                    float value = 0.0f;
                    if (responseValue instanceof BStruct) {
                        if (fieldDescriptor.isRepeated()) {
                            bValue = ((BStruct)responseValue).getRefField(refIndex++);
                            valueArray = (BFloatArray)bValue;
                            Float[] messages = new Float[(int)valueArray.size()];
                            int i = 0;
                            while ((long)i < valueArray.size()) {
                                float indexValue = Float.parseFloat(String.valueOf(valueArray.get((long)i)));
                                messages[i] = Float.valueOf(indexValue);
                                ++i;
                            }
                            responseBuilder.addField(fieldName, messages);
                            break;
                        }
                        value = Float.parseFloat(String.valueOf(((BStruct)responseValue).getFloatField(floatIndex++)));
                        responseBuilder.addField(fieldName, Float.valueOf(value));
                        break;
                    }
                    if (responseValue instanceof BFloat) {
                        value = Float.parseFloat(String.valueOf(((BFloat)responseValue).value()));
                    }
                    responseBuilder.addField(fieldName, Float.valueOf(value));
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    int i;
                    BRefType bValue;
                    long value = 0L;
                    if (responseValue instanceof BStruct) {
                        if (fieldDescriptor.isRepeated()) {
                            bValue = ((BStruct)responseValue).getRefField(refIndex++);
                            BIntArray valueArray = (BIntArray)bValue;
                            Long[] messages = new Long[(int)valueArray.size()];
                            i = 0;
                            while ((long)i < valueArray.size()) {
                                long indexValue = valueArray.get((long)i);
                                messages[i] = indexValue;
                                ++i;
                            }
                            responseBuilder.addField(fieldName, messages);
                            break;
                        }
                        value = ((BStruct)responseValue).getIntField(intIndex++);
                        responseBuilder.addField(fieldName, value);
                        break;
                    }
                    if (!(responseValue instanceof BInteger)) continue block10;
                    value = ((BInteger)responseValue).value();
                    responseBuilder.addField(fieldName, value);
                    break;
                }
                case 5: 
                case 7: {
                    int indexValue;
                    BFloatArray valueArray;
                    BRefType bValue;
                    int value = 0;
                    if (responseValue instanceof BStruct) {
                        if (fieldDescriptor.isRepeated()) {
                            bValue = ((BStruct)responseValue).getRefField(refIndex++);
                            valueArray = (BIntArray)bValue;
                            Integer[] messages = new Integer[(int)valueArray.size()];
                            int i = 0;
                            while ((long)i < valueArray.size()) {
                                indexValue = Integer.parseInt(String.valueOf(valueArray.get((long)i)));
                                messages[i] = indexValue;
                                ++i;
                            }
                            responseBuilder.addField(fieldName, messages);
                            break;
                        }
                        value = Integer.parseInt(String.valueOf(((BStruct)responseValue).getIntField(intIndex++)));
                        responseBuilder.addField(fieldName, value);
                        break;
                    }
                    if (responseValue instanceof BInteger) {
                        value = Integer.parseInt(String.valueOf(((BInteger)responseValue).value()));
                    }
                    responseBuilder.addField(fieldName, value);
                    break;
                }
                case 8: {
                    int indexValue;
                    BFloatArray valueArray;
                    BRefType bValue;
                    boolean value = false;
                    if (responseValue instanceof BStruct) {
                        if (fieldDescriptor.isRepeated()) {
                            bValue = ((BStruct)responseValue).getRefField(refIndex++);
                            valueArray = (BBooleanArray)bValue;
                            Boolean[] messages = new Boolean[(int)valueArray.size()];
                            int i = 0;
                            while ((long)i < valueArray.size()) {
                                indexValue = valueArray.get((long)i);
                                messages[i] = indexValue != 0;
                                ++i;
                            }
                            responseBuilder.addField(fieldName, messages);
                            break;
                        }
                        value = ((BStruct)responseValue).getBooleanField(boolIndex++) > 0;
                        responseBuilder.addField(fieldName, value);
                        break;
                    }
                    if (!(responseValue instanceof BBoolean)) continue block10;
                    value = ((BBoolean)responseValue).value();
                    responseBuilder.addField(fieldName, value);
                    break;
                }
                case 9: {
                    BFloatArray valueArray;
                    BRefType bValue;
                    String value = null;
                    if (responseValue instanceof BStruct) {
                        if (fieldDescriptor.isRepeated()) {
                            bValue = ((BStruct)responseValue).getRefField(refIndex++);
                            valueArray = (BStringArray)bValue;
                            String[] messages = new String[(int)valueArray.size()];
                            int i = 0;
                            while ((long)i < valueArray.size()) {
                                String indexValue;
                                messages[i] = indexValue = valueArray.get((long)i);
                                ++i;
                            }
                            responseBuilder.addField(fieldName, messages);
                            break;
                        }
                        value = ((BStruct)responseValue).getStringField(stringIndex++);
                        responseBuilder.addField(fieldName, value);
                        break;
                    }
                    if (responseValue instanceof BString) {
                        value = ((BString)responseValue).value();
                    }
                    responseBuilder.addField(fieldName, value);
                    break;
                }
                case 14: {
                    if (!(responseValue instanceof BStruct)) continue block10;
                    BRefType bValue = ((BStruct)responseValue).getRefField(refIndex++);
                    responseBuilder.addField(fieldName, fieldDescriptor.getEnumType().findValueByName(bValue.stringValue()));
                    break;
                }
                case 11: {
                    if (!(responseValue instanceof BStruct)) continue block10;
                    BRefType bValue = ((BStruct)responseValue).getRefField(refIndex++);
                    if (fieldDescriptor.isRepeated() && bValue instanceof BRefValueArray) {
                        BRefValueArray valueArray = (BRefValueArray)bValue;
                        Message[] messages = new Message[(int)valueArray.size()];
                        int i = 0;
                        while ((long)i < valueArray.size()) {
                            BRefType value = valueArray.get((long)i);
                            messages[i] = MessageUtils.generateProtoMessage((BValue)value, fieldDescriptor.getMessageType());
                            ++i;
                        }
                        responseBuilder.addField(fieldName, messages);
                        break;
                    }
                    responseBuilder.addField(fieldName, (Object)MessageUtils.generateProtoMessage((BValue)bValue, fieldDescriptor.getMessageType()));
                    break;
                }
                default: {
                    throw new UnsupportedFieldTypeException("Error while decoding request message. Field type is not supported : " + fieldDescriptor.getType());
                }
            }
        }
        return responseBuilder.build();
    }

    public static BValue generateRequestStruct(Message request, ProgramFile programFile, String fieldName, BType structType) {
        BString bValue = null;
        Map<String, Object> fields = request.getFields();
        if (fields.size() == 1 && fields.containsKey("value")) {
            fieldName = "value";
        }
        if (TypeKind.STRING.typeName().equals(structType.getName())) {
            bValue = new BString((String)fields.get(fieldName));
        } else if (TypeKind.INT.typeName().equals(structType.getName())) {
            bValue = new BInteger(((Long)fields.get(fieldName)).longValue());
        } else if (TypeKind.FLOAT.typeName().equals(structType.getName())) {
            Float value = (Float)request.getFields().get(fieldName);
            if (value != null) {
                bValue = new BFloat(Double.parseDouble(value.toString()));
            }
        } else if (TypeKind.BOOLEAN.typeName().equals(structType.getName())) {
            bValue = new BBoolean(((Boolean)fields.get(fieldName)).booleanValue());
        } else if (structType instanceof BStructType) {
            BStruct requestStruct = BLangConnectorSPIUtil.createBStruct((ProgramFile)programFile, (String)structType.getPackagePath(), (String)structType.getName(), (Object[])new Object[0]);
            int stringIndex = 0;
            int intIndex = 0;
            int floatIndex = 0;
            int boolIndex = 0;
            int refIndex = 0;
            for (BStructType.StructField structField : ((BStructType)structType).getStructFields()) {
                BStringArray bArrayValue;
                List messages;
                String structFieldName = structField.getFieldName();
                BType structFieldType = structField.getFieldType();
                if (TypeKind.STRING.typeName().equals(structFieldType.getName())) {
                    BString bStringValue = (BString)MessageUtils.generateRequestStruct(request, programFile, structFieldName, structFieldType);
                    requestStruct.setStringField(stringIndex++, bStringValue.stringValue());
                    continue;
                }
                if (TypeKind.INT.typeName().equals(structFieldType.getName())) {
                    BInteger bIntegerValue = (BInteger)MessageUtils.generateRequestStruct(request, programFile, structFieldName, structFieldType);
                    requestStruct.setIntField(intIndex++, bIntegerValue.value().longValue());
                    continue;
                }
                if (TypeKind.FLOAT.typeName().equals(structFieldType.getName())) {
                    BFloat bFloatValue = (BFloat)MessageUtils.generateRequestStruct(request, programFile, structFieldName, structFieldType);
                    requestStruct.setFloatField(floatIndex++, bFloatValue.value().doubleValue());
                    continue;
                }
                if (TypeKind.BOOLEAN.typeName().equals(structFieldType.getName())) {
                    BBoolean bBooleanValue = (BBoolean)MessageUtils.generateRequestStruct(request, programFile, structFieldName, structFieldType);
                    requestStruct.setBooleanField(boolIndex++, bBooleanValue.value() != false ? 1 : 0);
                    continue;
                }
                if (structFieldType instanceof BStructType) {
                    if (!MessageRegistry.getInstance().getMessageDescriptorMap().containsKey(structFieldType.getName())) continue;
                    Message message = (Message)((Object)fields.get(structFieldName));
                    requestStruct.setRefField(refIndex++, (BRefType)MessageUtils.generateRequestStruct(message, programFile, structFieldName, structField.getFieldType()));
                    continue;
                }
                if (!(structFieldType instanceof BArrayType)) continue;
                long arrayIndex = 0L;
                BArrayType fieldArrayType = (BArrayType)structFieldType;
                BType elementType = fieldArrayType.getElementType();
                if (!(fields.get(structFieldName) instanceof List)) {
                    throw new RuntimeException("Error while creating message struct. message value should be an instance of List");
                }
                if (TypeKind.STRING.typeName().equals(elementType.getName())) {
                    messages = (List)fields.get(structFieldName);
                    bArrayValue = new BStringArray();
                    for (String stringValue : messages) {
                        bArrayValue.add(arrayIndex++, stringValue);
                    }
                    requestStruct.setRefField(refIndex++, (BRefType)bArrayValue);
                    continue;
                }
                if (TypeKind.INT.typeName().equals(elementType.getName())) {
                    messages = (List)fields.get(structFieldName);
                    bArrayValue = new BIntArray();
                    for (Long integerValue : messages) {
                        bArrayValue.add(arrayIndex++, integerValue.longValue());
                    }
                    requestStruct.setRefField(refIndex++, (BRefType)bArrayValue);
                    continue;
                }
                if (TypeKind.FLOAT.typeName().equals(elementType.getName())) {
                    messages = (List)fields.get(structFieldName);
                    bArrayValue = new BFloatArray();
                    for (Float floatValue : messages) {
                        bArrayValue.add(arrayIndex++, Double.parseDouble(floatValue.toString()));
                    }
                    requestStruct.setRefField(refIndex++, (BRefType)bArrayValue);
                    continue;
                }
                if (TypeKind.BOOLEAN.typeName().equals(elementType.getName())) {
                    messages = (List)fields.get(structFieldName);
                    bArrayValue = new BBooleanArray();
                    for (Boolean booleanValue : messages) {
                        bArrayValue.add(arrayIndex++, booleanValue != false ? 1 : 0);
                    }
                    requestStruct.setRefField(refIndex++, (BRefType)bArrayValue);
                    continue;
                }
                if (!(elementType instanceof BStructType)) continue;
                messages = (List)fields.get(structFieldName);
                bArrayValue = new BRefValueArray(elementType);
                for (Message message : messages) {
                    bArrayValue.add(arrayIndex++, (BRefType)MessageUtils.generateRequestStruct(message, programFile, structFieldName, elementType));
                }
                requestStruct.setRefField(refIndex++, (BRefType)bArrayValue);
            }
            bValue = requestStruct;
        }
        return bValue;
    }

    public static MethodDescriptor.MethodType getMethodType(DescriptorProtos.MethodDescriptorProto methodDescriptorProto) {
        if (methodDescriptorProto.getClientStreaming() && methodDescriptorProto.getServerStreaming()) {
            return MethodDescriptor.MethodType.BIDI_STREAMING;
        }
        if (!methodDescriptorProto.getClientStreaming() && !methodDescriptorProto.getServerStreaming()) {
            return MethodDescriptor.MethodType.UNARY;
        }
        if (methodDescriptorProto.getServerStreaming()) {
            return MethodDescriptor.MethodType.SERVER_STREAMING;
        }
        if (methodDescriptorProto.getClientStreaming()) {
            return MethodDescriptor.MethodType.CLIENT_STREAMING;
        }
        return MethodDescriptor.MethodType.UNKNOWN;
    }

    public static boolean isEmptyResponse(Descriptors.Descriptor messageDescriptor) {
        if (messageDescriptor == null) {
            return false;
        }
        List descriptors = EmptyProto.getDescriptor().getMessageTypes();
        for (Descriptors.Descriptor descriptor : descriptors) {
            if (!descriptor.equals(messageDescriptor)) continue;
            return true;
        }
        return false;
    }
}

