/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.components;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.net.grpc.builder.components.BlockingFunction;
import org.ballerinalang.net.grpc.builder.components.NonBlockingFunction;
import org.ballerinalang.net.grpc.builder.components.StreamingFunction;
import org.ballerinalang.net.grpc.builder.components.Stub;

public class StubObject {
    private String stubType;
    private String connectorId;
    private List<Stub> stubs = new ArrayList<Stub>();
    private List<BlockingFunction> blockingFunctions = new ArrayList<BlockingFunction>();
    private List<NonBlockingFunction> nonBlockingFunctions = new ArrayList<NonBlockingFunction>();
    private List<StreamingFunction> streamingFunctions = new ArrayList<StreamingFunction>();

    public StubObject(String connectorId) {
        this.connectorId = connectorId;
    }

    public void addStub(String stubTypeName, String stubType) {
        Stub stub = new Stub(this.connectorId, stubTypeName, stubType);
        this.stubs.add(stub);
    }

    public void addBlockingFunction(String operationId, String inputDataType, String outputDataType, String methodId) {
        BlockingFunction blockingFunctionsObj = new BlockingFunction("Blocking", this.connectorId, operationId, inputDataType, outputDataType, methodId);
        if ("Empty".equals(inputDataType)) {
            blockingFunctionsObj.setInputComma(null);
            blockingFunctionsObj.setInputAttributeName(null);
            blockingFunctionsObj.setInputDataType(null);
            blockingFunctionsObj.initEmptyStruct();
        }
        if ("Empty".equals(outputDataType)) {
            blockingFunctionsObj.setOutputComma(null);
            blockingFunctionsObj.setOutputDataType(null);
            blockingFunctionsObj.ignoreCast();
        }
        this.blockingFunctions.add(blockingFunctionsObj);
    }

    public void addNonBlockingFunction(String operationId, String inputDataType, String methodId) {
        NonBlockingFunction nonBlockingFunctionsObj = new NonBlockingFunction(null, this.connectorId, operationId, inputDataType, methodId);
        if ("Empty".equals(inputDataType)) {
            nonBlockingFunctionsObj.setInputComma(null);
            nonBlockingFunctionsObj.setInputAttributeName(null);
            nonBlockingFunctionsObj.setInputDataType(null);
        }
        this.nonBlockingFunctions.add(nonBlockingFunctionsObj);
    }

    public void addStreamingFunction(String operationId, String inputDataType, String methodId) {
        StreamingFunction streamingFunctionsObj = new StreamingFunction("NonBlocking", this.connectorId, operationId, inputDataType, methodId);
        this.streamingFunctions.add(streamingFunctionsObj);
    }

    public List<Stub> getStubs() {
        return this.stubs;
    }

    public void setStubs(List<Stub> stubs) {
        this.stubs = stubs;
    }

    public List getBlockingFunction() {
        return this.blockingFunctions;
    }

    public void setBlockingFunction(List<BlockingFunction> blockingFunctions) {
        this.blockingFunctions = blockingFunctions;
    }

    public List getNonBlockingFunction() {
        return this.nonBlockingFunctions;
    }

    public void setNonBlockingFunction(List<NonBlockingFunction> nonBlockingFunctions) {
        this.nonBlockingFunctions = nonBlockingFunctions;
    }

    public List getStreamingFunction() {
        return this.streamingFunctions;
    }

    public void setStreamingFunction(List<StreamingFunction> streamingFunctions) {
        this.streamingFunctions = streamingFunctions;
    }

    public boolean isFunctionsStreamingNotEmpty() {
        return !this.nonBlockingFunctions.isEmpty() || !this.streamingFunctions.isEmpty();
    }

    public boolean isFunctionsUnaryNotEmpty() {
        return !this.blockingFunctions.isEmpty();
    }

    public String getStubType() {
        return this.stubType;
    }

    public void setStubType(String stubType) {
        this.stubType = stubType;
    }
}

