/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.clientendpoint;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.ssl.SSLHandlerFactory;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.transport.http.netty.config.Parameter;
import org.wso2.transport.http.netty.config.SenderConfiguration;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="init", receiver=@Receiver(type=TypeKind.STRUCT, structType="Client", structPackage="ballerina.grpc"), args={@Argument(name="config", type=TypeKind.STRUCT, structType="ClientEndpointConfig")}, isPublic=true)
public class Init
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        try {
            ManagedChannel channel;
            URL url;
            Struct clientEndpoint = BLangConnectorSPIUtil.getConnectorEndpointStruct((Context)context);
            BStruct endpointConfigStruct = (BStruct)context.getRefArgument(1);
            Struct endpointConfig = BLangConnectorSPIUtil.toStruct((BStruct)endpointConfigStruct);
            String urlString = endpointConfig.getStringField("url");
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                throw new BallerinaException("Malformed URL: " + urlString);
            }
            String scheme = url.getProtocol();
            SenderConfiguration configuration = this.populateSenderConfigurationOptions(endpointConfig, scheme);
            if (configuration.getSSLConfig() == null) {
                channel = ManagedChannelBuilder.forAddress((String)url.getHost(), (int)url.getPort()).usePlaintext(true).build();
            } else {
                SslContext sslContext = new SSLHandlerFactory(configuration.getSSLConfig()).createHttp2TLSContextForClient();
                channel = ((NettyChannelBuilder)NettyChannelBuilder.forAddress((SocketAddress)Init.generateSocketAddress(url.getHost(), url.getPort())).flowControlWindow(66560).maxInboundMessageSize(0x1000000)).sslContext(sslContext).build();
            }
            clientEndpoint.addNativeData("channel", (Object)channel);
        }
        catch (Throwable throwable) {
            BStruct errorStruct = MessageUtils.getConnectorError(context, throwable);
            context.setError(errorStruct);
        }
    }

    private static InetSocketAddress generateSocketAddress(String host, int port) {
        try {
            InetAddress inetAddress = InetAddress.getByName("localhost");
            inetAddress = InetAddress.getByAddress(host, inetAddress.getAddress());
            return new InetSocketAddress(inetAddress, port);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private SenderConfiguration populateSenderConfigurationOptions(Struct clientEndpointConfig, String scheme) {
        SenderConfiguration senderConfiguration = new SenderConfiguration();
        senderConfiguration.setScheme(scheme);
        Struct secureSocket = clientEndpointConfig.getStructField("secureSocket");
        if (secureSocket != null) {
            Struct trustStore = secureSocket.getStructField("trustStore");
            Struct keyStore = secureSocket.getStructField("keyStore");
            Struct protocols = secureSocket.getStructField("protocol");
            Struct validateCert = secureSocket.getStructField("certValidation");
            ArrayList<Parameter> clientParams = new ArrayList<Parameter>();
            if (trustStore != null) {
                String trustStorePassword;
                String trustStoreFile = trustStore.getStringField("path");
                if (StringUtils.isNotBlank((CharSequence)trustStoreFile)) {
                    senderConfiguration.setTrustStoreFile(trustStoreFile);
                }
                if (StringUtils.isNotBlank((CharSequence)(trustStorePassword = trustStore.getStringField("password")))) {
                    senderConfiguration.setTrustStorePass(trustStorePassword);
                }
            }
            if (keyStore != null) {
                String keyStorePassword;
                String keyStoreFile = keyStore.getStringField("path");
                if (StringUtils.isNotBlank((CharSequence)keyStoreFile)) {
                    senderConfiguration.setKeyStoreFile(keyStoreFile);
                }
                if (StringUtils.isNotBlank((CharSequence)(keyStorePassword = keyStore.getStringField("password")))) {
                    senderConfiguration.setKeyStorePassword(keyStorePassword);
                }
            }
            if (protocols != null) {
                String sslProtocol;
                List<Value> sslEnabledProtocolsValueList = Arrays.asList(protocols.getArrayField("versions"));
                if (sslEnabledProtocolsValueList.size() > 0) {
                    String sslEnabledProtocols = sslEnabledProtocolsValueList.stream().map(Value::getStringValue).collect(Collectors.joining(",", "", ""));
                    Parameter clientProtocols = new Parameter("sslEnabledProtocols", sslEnabledProtocols);
                    clientParams.add(clientProtocols);
                }
                if (StringUtils.isNotBlank((CharSequence)(sslProtocol = protocols.getStringField("name")))) {
                    senderConfiguration.setSSLProtocol(sslProtocol);
                }
            }
            if (validateCert != null) {
                boolean validateCertEnabled = validateCert.getBooleanField("enable");
                int cacheSize = (int)validateCert.getIntField("cacheSize");
                int cacheValidityPeriod = (int)validateCert.getIntField("cacheValidityPeriod");
                senderConfiguration.setValidateCertEnabled(validateCertEnabled);
                if (cacheValidityPeriod != 0) {
                    senderConfiguration.setCacheValidityPeriod(cacheValidityPeriod);
                }
                if (cacheSize != 0) {
                    senderConfiguration.setCacheSize(cacheSize);
                }
            }
            boolean hostNameVerificationEnabled = secureSocket.getBooleanField("verifyHostname");
            boolean ocspStaplingEnabled = secureSocket.getBooleanField("ocspStapling");
            senderConfiguration.setOcspStaplingEnabled(ocspStaplingEnabled);
            senderConfiguration.setHostNameVerificationEnabled(hostNameVerificationEnabled);
            List<Value> ciphersValueList = Arrays.asList(secureSocket.getArrayField("ciphers"));
            if (ciphersValueList.size() > 0) {
                String ciphers = ciphersValueList.stream().map(Value::getStringValue).collect(Collectors.joining(",", "", ""));
                Parameter clientCiphers = new Parameter("ciphers", ciphers);
                clientParams.add(clientCiphers);
            }
            String enableSessionCreation = String.valueOf(secureSocket.getBooleanField("shareSession"));
            Parameter clientEnableSessionCreation = new Parameter("shareSession", enableSessionCreation);
            clientParams.add(clientEnableSessionCreation);
            if (!clientParams.isEmpty()) {
                senderConfiguration.setParameters(clientParams);
            }
        }
        return senderConfiguration;
    }
}

