/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.proto;

import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedAnnotationPackages;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.net.grpc.exception.GrpcServerException;
import org.ballerinalang.net.grpc.proto.ServiceProtoUtils;
import org.ballerinalang.net.grpc.proto.definition.File;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;

@SupportedAnnotationPackages(value={"ballerina.grpc"})
public class ServiceProtoBuilder
extends AbstractCompilerPlugin {
    private boolean canProcess;
    private DiagnosticLog dlog;
    private Map<String, File> serviceFileMap = new HashMap<String, File>();
    private static final PrintStream error = System.err;

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
        this.canProcess = false;
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        for (AnnotationAttachmentNode annotationNode : annotations) {
            if (!"messageListener".equals(annotationNode.getAnnotationName().getValue())) continue;
            return;
        }
        try {
            File fileDefinition = ServiceProtoUtils.generateProtoDefinition(serviceNode);
            ServiceProtoUtils.writeServiceFiles(Paths.get(".", new String[0]), serviceNode.getName().getValue(), fileDefinition);
            this.serviceFileMap.put(serviceNode.getName().getValue(), fileDefinition);
        }
        catch (GrpcServerException e) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)e.getMessage());
        }
    }

    public void codeGenerated(Path binaryPath) {
        if (this.canProcess) {
            if (binaryPath == null) {
                error.print("Error while generating service proto file. Binary file path is null");
                return;
            }
            Path filePath = binaryPath.toAbsolutePath();
            Path parentDirPath = filePath.getParent();
            if (parentDirPath == null) {
                parentDirPath = filePath;
            }
            Path targetDirPath = Paths.get(parentDirPath.toString(), "grpc");
            for (Map.Entry<String, File> entry : this.serviceFileMap.entrySet()) {
                try {
                    ServiceProtoUtils.writeServiceFiles(targetDirPath, entry.getKey(), entry.getValue());
                }
                catch (GrpcServerException e) {
                    error.print("Error while generating service proto file. " + e.getMessage());
                }
            }
        }
    }
}

