/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.proto;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ResourceNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.statements.BlockNode;
import org.ballerinalang.model.tree.statements.StatementNode;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.net.grpc.config.ServiceConfiguration;
import org.ballerinalang.net.grpc.exception.GrpcServerException;
import org.ballerinalang.net.grpc.proto.definition.EmptyMessage;
import org.ballerinalang.net.grpc.proto.definition.EnumField;
import org.ballerinalang.net.grpc.proto.definition.Field;
import org.ballerinalang.net.grpc.proto.definition.File;
import org.ballerinalang.net.grpc.proto.definition.Message;
import org.ballerinalang.net.grpc.proto.definition.MessageKind;
import org.ballerinalang.net.grpc.proto.definition.Method;
import org.ballerinalang.net.grpc.proto.definition.Service;
import org.ballerinalang.net.grpc.proto.definition.StandardDescriptorBuilder;
import org.ballerinalang.net.grpc.proto.definition.StructMessage;
import org.ballerinalang.net.grpc.proto.definition.UserDefinedEnumMessage;
import org.ballerinalang.net.grpc.proto.definition.UserDefinedMessage;
import org.ballerinalang.net.grpc.proto.definition.WrapperMessage;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BEnumType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.util.Name;

public class ServiceProtoUtils {
    private static final String NO_PACKAGE_PATH = ".";

    static File generateProtoDefinition(ServiceNode serviceNode) throws GrpcServerException {
        String packageName = serviceNode.getPosition().getSource().getPackageName();
        File.Builder fileBuilder = !NO_PACKAGE_PATH.equals(packageName) ? File.newBuilder(serviceNode.getName() + ".proto").setSyntax("proto3").setPackage(serviceNode.getPosition().getSource().getPackageName()) : File.newBuilder(serviceNode.getName() + ".proto").setSyntax("proto3");
        ServiceConfiguration serviceConfig = ServiceProtoUtils.getServiceConfiguration(serviceNode);
        Service serviceDefinition = serviceConfig.getRpcEndpoint() != null && serviceConfig.isClientStreaming() ? ServiceProtoUtils.getStreamingServiceDefinition(serviceNode, serviceConfig, fileBuilder) : ServiceProtoUtils.getUnaryServiceDefinition(serviceNode, fileBuilder);
        fileBuilder.setService(serviceDefinition);
        return fileBuilder.build();
    }

    static ServiceConfiguration getServiceConfiguration(ServiceNode serviceNode) {
        String rpcEndpoint = null;
        boolean clientStreaming = false;
        boolean serverStreaming = false;
        for (AnnotationAttachmentNode annotationNode : serviceNode.getAnnotationAttachments()) {
            if (!"serviceConfig".equals(annotationNode.getAnnotationName().getValue()) || !(annotationNode.getExpression() instanceof BLangRecordLiteral)) continue;
            List attributes = ((BLangRecordLiteral)annotationNode.getExpression()).getKeyValuePairs();
            for (BLangRecordLiteral.BLangRecordKeyValue attributeNode : attributes) {
                String attributeName = attributeNode.getKey().toString();
                String attributeValue = attributeNode.getValue() != null ? attributeNode.getValue().toString() : null;
                switch (attributeName) {
                    case "name": {
                        rpcEndpoint = attributeValue;
                        break;
                    }
                    case "clientStreaming": {
                        clientStreaming = attributeValue != null && Boolean.parseBoolean(attributeValue);
                        break;
                    }
                    case "serverStreaming": {
                        serverStreaming = attributeValue != null && Boolean.parseBoolean(attributeValue);
                        break;
                    }
                }
            }
        }
        return new ServiceConfiguration(rpcEndpoint, clientStreaming, serverStreaming);
    }

    private static Service getUnaryServiceDefinition(ServiceNode serviceNode, File.Builder fileBuilder) throws GrpcServerException {
        Service.Builder serviceBuilder = Service.newBuilder(serviceNode.getName().getValue());
        for (ResourceNode resourceNode : serviceNode.getResources()) {
            Message responseMessage;
            Message requestMessage = ServiceProtoUtils.getRequestMessage(resourceNode);
            if (requestMessage.getMessageKind() == MessageKind.USER_DEFINED) {
                ServiceProtoUtils.updateFileBuilder(fileBuilder, requestMessage);
            }
            if (requestMessage.getDependency() != null && !fileBuilder.getRegisteredDependencies().contains(requestMessage.getDependency())) {
                fileBuilder.setDependency(requestMessage.getDependency());
            }
            if ((responseMessage = ServiceProtoUtils.getResponseMessage(resourceNode)) == null) {
                throw new GrpcServerException("Connection send expression not found in resource body");
            }
            if (responseMessage.getMessageKind() == MessageKind.USER_DEFINED) {
                ServiceProtoUtils.updateFileBuilder(fileBuilder, responseMessage);
            }
            if (responseMessage.getDependency() != null && !fileBuilder.getRegisteredDependencies().contains(responseMessage.getDependency())) {
                fileBuilder.setDependency(responseMessage.getDependency());
            }
            boolean serverStreaming = ServiceProtoUtils.isServerStreaming(resourceNode);
            Method resourceMethod = Method.newBuilder(resourceNode.getName().getValue()).setClientStreaming(false).setServerStreaming(serverStreaming).setInputType(requestMessage.getCanonicalName()).setOutputType(responseMessage.getCanonicalName()).build();
            serviceBuilder.addMethod(resourceMethod);
        }
        return serviceBuilder.build();
    }

    private static boolean isNewMessageDefinition(File.Builder fileBuilder, Message message) {
        for (DescriptorProtos.DescriptorProto messageProto : fileBuilder.getRegisteredMessages()) {
            if (messageProto.getName() == null || !messageProto.getName().equals(message.getSimpleName())) continue;
            return false;
        }
        return true;
    }

    private static boolean isNewEnumDefinition(File.Builder fileBuilder, Message enumMsg) {
        for (DescriptorProtos.EnumDescriptorProto enumDescriptorProto : fileBuilder.getRegisteredEnums()) {
            if (enumDescriptorProto.getName() == null || !enumDescriptorProto.getName().equals(enumMsg.getSimpleName())) continue;
            return false;
        }
        return true;
    }

    private static Service getStreamingServiceDefinition(ServiceNode serviceNode, ServiceConfiguration serviceConfig, File.Builder fileBuilder) throws GrpcServerException {
        Service.Builder serviceBuilder = Service.newBuilder(serviceNode.getName().getValue());
        Message requestMessage = null;
        Message responseMessage = null;
        for (ResourceNode resourceNode : serviceNode.getResources()) {
            Message respMsg;
            if ("onMessage".equals(resourceNode.getName().getValue())) {
                requestMessage = ServiceProtoUtils.getRequestMessage(resourceNode);
                respMsg = ServiceProtoUtils.getResponseMessage(resourceNode);
                if (respMsg != null && !MessageKind.EMPTY.equals((Object)respMsg.getMessageKind())) {
                    responseMessage = respMsg;
                    break;
                }
            }
            if (!"onComplete".equals(resourceNode.getName().getValue()) || (respMsg = ServiceProtoUtils.getResponseMessage(resourceNode)) == null || MessageKind.EMPTY.equals((Object)respMsg.getMessageKind())) continue;
            responseMessage = respMsg;
        }
        if (requestMessage == null) {
            requestMessage = ServiceProtoUtils.generateMessageDefinition((BType)new BNilType());
        }
        if (responseMessage == null) {
            responseMessage = ServiceProtoUtils.generateMessageDefinition((BType)new BNilType());
        }
        if (requestMessage.getMessageKind() == MessageKind.USER_DEFINED) {
            ServiceProtoUtils.updateFileBuilder(fileBuilder, requestMessage);
        }
        if (requestMessage.getDependency() != null && !fileBuilder.getRegisteredDependencies().contains(requestMessage.getDependency())) {
            fileBuilder.setDependency(requestMessage.getDependency());
        }
        if (responseMessage.getMessageKind() == MessageKind.USER_DEFINED) {
            ServiceProtoUtils.updateFileBuilder(fileBuilder, responseMessage);
        }
        if (responseMessage.getDependency() != null && !fileBuilder.getRegisteredDependencies().contains(responseMessage.getDependency())) {
            fileBuilder.setDependency(responseMessage.getDependency());
        }
        Method resourceMethod = Method.newBuilder(serviceConfig.getRpcEndpoint()).setClientStreaming(serviceConfig.isClientStreaming()).setServerStreaming(serviceConfig.isServerStreaming()).setInputType(requestMessage.getCanonicalName()).setOutputType(responseMessage.getCanonicalName()).build();
        serviceBuilder.addMethod(resourceMethod);
        return serviceBuilder.build();
    }

    private static void updateFileBuilder(File.Builder fileBuilder, Message message) {
        if (ServiceProtoUtils.isNewMessageDefinition(fileBuilder, message)) {
            fileBuilder.setMessage(message);
        }
        for (UserDefinedMessage msg : message.getNestedMessageList()) {
            if (!ServiceProtoUtils.isNewMessageDefinition(fileBuilder, msg)) continue;
            fileBuilder.setMessage(msg);
        }
        for (UserDefinedEnumMessage enumMessage : message.getNestedEnumList()) {
            if (!ServiceProtoUtils.isNewEnumDefinition(fileBuilder, enumMessage)) continue;
            fileBuilder.setEnum(enumMessage);
        }
    }

    private static boolean isServerStreaming(ResourceNode resourceNode) {
        boolean serverStreaming = false;
        for (AnnotationAttachmentNode annotationNode : resourceNode.getAnnotationAttachments()) {
            if (!"resourceConfig".equals(annotationNode.getAnnotationName().getValue()) || !(annotationNode.getExpression() instanceof BLangRecordLiteral)) continue;
            List attributes = ((BLangRecordLiteral)annotationNode.getExpression()).getKeyValuePairs();
            for (BLangRecordLiteral.BLangRecordKeyValue attributeNode : attributes) {
                String attributeValue;
                String attributeName = attributeNode.getKey().toString();
                String string = attributeValue = attributeNode.getValue() != null ? attributeNode.getValue().toString() : null;
                if (!"streaming".equals(attributeName)) continue;
                serverStreaming = attributeValue != null && Boolean.parseBoolean(attributeValue);
            }
        }
        return serverStreaming;
    }

    private static Message getResponseMessage(ResourceNode resourceNode) throws GrpcServerException {
        BLangInvocation sendExpression = ServiceProtoUtils.getInvocationExpression(resourceNode.getBody());
        Object responseType = sendExpression != null ? ServiceProtoUtils.getReturnType(sendExpression) : new BNilType();
        return ServiceProtoUtils.generateMessageDefinition(responseType);
    }

    private static Message getRequestMessage(ResourceNode resourceNode) throws GrpcServerException {
        if (resourceNode.getParameters().size() <= 0 && resourceNode.getParameters().size() >= 4) {
            throw new GrpcServerException("Service resource definition should contain more than one and less than four params. but contains " + resourceNode.getParameters().size());
        }
        BType requestType = ServiceProtoUtils.getMessageParamType(resourceNode.getParameters());
        return ServiceProtoUtils.generateMessageDefinition(requestType);
    }

    private static BType getMessageParamType(List<?> variableNodes) throws GrpcServerException {
        BNilType requestType = null;
        for (Object variable : variableNodes) {
            if (variable instanceof BLangNode) {
                BType tempType = ((BLangNode)variable).type;
                if (tempType.getKind().equals((Object)TypeKind.ARRAY)) {
                    requestType = tempType;
                    break;
                }
                if ("ballerina.grpc:Listener".equals(tempType.tsymbol.toString()) || "ballerina.grpc:Headers".equals(tempType.tsymbol.toString())) continue;
                requestType = tempType;
                break;
            }
            throw new GrpcServerException("Request Message type is not supported, should be lang variable.");
        }
        if (requestType == null) {
            requestType = new BNilType();
        }
        return requestType;
    }

    private static Message generateMessageDefinition(BType messageType) throws GrpcServerException {
        Message message = null;
        switch (messageType.getKind()) {
            case STRING: {
                message = WrapperMessage.newBuilder("StringValue").build();
                break;
            }
            case INT: {
                message = WrapperMessage.newBuilder("Int64Value").build();
                break;
            }
            case FLOAT: {
                message = WrapperMessage.newBuilder("FloatValue").build();
                break;
            }
            case BOOLEAN: {
                message = WrapperMessage.newBuilder("BoolValue").build();
                break;
            }
            case STRUCT: {
                if (!(messageType instanceof BStructType)) break;
                BStructType structType = (BStructType)messageType;
                message = ServiceProtoUtils.getStructMessage(structType);
                break;
            }
            case ENUM: {
                if (!(messageType instanceof BEnumType)) break;
                BEnumType enumType = (BEnumType)messageType;
                message = ServiceProtoUtils.getEnumMessage(enumType);
                break;
            }
            case NIL: {
                message = EmptyMessage.newBuilder().build();
                break;
            }
            case ARRAY: {
                message = StructMessage.newBuilder("ListValue").build();
                break;
            }
            default: {
                throw new GrpcServerException("Unsupported field type, field type " + messageType.getKind().typeName() + " currently not supported.");
            }
        }
        return message;
    }

    private static Message getStructMessage(BStructType messageType) throws GrpcServerException {
        UserDefinedMessage.Builder messageBuilder = UserDefinedMessage.newBuilder(messageType.toString());
        int fieldIndex = 0;
        for (BStructType.BStructField structField : messageType.fields) {
            String fieldName = structField.getName().getValue();
            String fieldType = structField.getType().toString();
            String fieldLabel = null;
            BType type = structField.getType();
            if (type instanceof BEnumType) {
                BEnumType enumType = (BEnumType)type;
                messageBuilder.addMessageDefinition(ServiceProtoUtils.getEnumMessage(enumType));
            } else if (type instanceof BStructType) {
                BStructType structType = (BStructType)type;
                messageBuilder.addMessageDefinition(ServiceProtoUtils.getStructMessage(structType));
            } else if (type instanceof BArrayType) {
                BArrayType arrayType = (BArrayType)type;
                BType elementType = arrayType.getElementType();
                if (elementType instanceof BStructType) {
                    messageBuilder.addMessageDefinition(ServiceProtoUtils.getStructMessage((BStructType)elementType));
                }
                fieldType = elementType.toString();
                fieldLabel = "repeated";
            }
            Field messageField = Field.newBuilder(fieldName).setIndex(++fieldIndex).setLabel(fieldLabel).setType(fieldType).build();
            messageBuilder.addFieldDefinition(messageField);
        }
        return messageBuilder.build();
    }

    private static UserDefinedEnumMessage getEnumMessage(BEnumType messageType) throws GrpcServerException {
        UserDefinedEnumMessage.Builder messageBuilder = UserDefinedEnumMessage.newBuilder(messageType.toString());
        int fieldIndex = 0;
        Map enumField = messageType.tsymbol.scope.entries;
        for (Map.Entry field : enumField.entrySet()) {
            String fieldName = ((Name)field.getKey()).getValue();
            EnumField messageField = EnumField.newBuilder().setName(fieldName).setIndex(fieldIndex++).build();
            messageBuilder.addFieldDefinition(messageField);
        }
        return messageBuilder.build();
    }

    private static BLangInvocation getInvocationExpression(BlockNode body) {
        if (body == null) {
            return null;
        }
        for (StatementNode statementNode : body.getStatements()) {
            BLangInvocation invocation;
            BLangForeach langForeach;
            BLangWhile langWhile;
            BLangInvocation invocExp;
            BLangExpression expression = null;
            if (statementNode instanceof BLangWhile && (invocExp = ServiceProtoUtils.getInvocationExpression((BlockNode)(langWhile = (BLangWhile)statementNode).getBody())) != null) {
                return invocExp;
            }
            if (statementNode instanceof BLangForeach && (invocExp = ServiceProtoUtils.getInvocationExpression((langForeach = (BLangForeach)statementNode).getBody())) != null) {
                return invocExp;
            }
            if (statementNode instanceof BLangIf) {
                BLangIf langIf = (BLangIf)statementNode;
                invocExp = ServiceProtoUtils.getInvocationExpression((BlockNode)langIf.getBody());
                if (invocExp != null) {
                    return invocExp;
                }
                invocExp = ServiceProtoUtils.getInvocationExpression((BlockNode)((BLangBlockStmt)langIf.getElseStatement()));
                if (invocExp != null) {
                    return invocExp;
                }
            }
            if (statementNode instanceof BLangAssignment) {
                BLangAssignment assignment = (BLangAssignment)statementNode;
                expression = assignment.getExpression();
            }
            if (statementNode instanceof BLangVariableDef) {
                BLangVariableDef variableDef = (BLangVariableDef)statementNode;
                BLangVariable variable = variableDef.getVariable();
                expression = variable.getInitialExpression();
            }
            if (expression == null || !(expression instanceof BLangInvocation) || !"send".equals((invocation = (BLangInvocation)expression).getName().getValue())) continue;
            return invocation;
        }
        return null;
    }

    private static BType getReturnType(BLangInvocation invocation) throws GrpcServerException {
        if (invocation.getArgumentExpressions() != null && invocation.getArgumentExpressions().size() > 2) {
            throw new GrpcServerException("Incorrect argument expressions defined in send function: " + invocation.toString());
        }
        return ServiceProtoUtils.getMessageParamType(invocation.getArgumentExpressions());
    }

    public static Descriptors.FileDescriptor getDescriptor(org.ballerinalang.connector.api.Service service) {
        try {
            Path path = Paths.get(service.getName() + ".desc", new String[0]);
            byte[] descriptor = Files.readAllBytes(path);
            DescriptorProtos.FileDescriptorProto proto = DescriptorProtos.FileDescriptorProto.parseFrom((byte[])descriptor);
            Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)proto, (Descriptors.FileDescriptor[])StandardDescriptorBuilder.getFileDescriptors(proto.getDependencyList().toArray()));
            Files.delete(path);
            return fileDescriptor;
        }
        catch (Descriptors.DescriptorValidationException | IOException e) {
            throw new BallerinaException("Error while reading the service proto descriptor. check the service implementation. ", e);
        }
    }

    static void writeServiceFiles(Path targetDirPath, String filename, File protoFileDefinition) throws GrpcServerException {
        if (targetDirPath == null) {
            throw new GrpcServerException("Target file directory path is null");
        }
        try {
            Path protoFilePath = Paths.get(targetDirPath.toString(), filename + ".proto");
            Files.write(protoFilePath, protoFileDefinition.getFileDefinition().getBytes("UTF-8"), new OpenOption[0]);
            byte[] fileDescriptor = protoFileDefinition.getFileDescriptorProto().toByteArray();
            Path descFilePath = Paths.get(targetDirPath.toString(), filename + ".desc");
            Files.write(descFilePath, fileDescriptor, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new GrpcServerException("Error while writing file descriptor to file.", e);
        }
    }
}

