/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.proto.definition;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.net.grpc.exception.GrpcServerException;
import org.ballerinalang.net.grpc.proto.ServiceProtoConstants;
import org.ballerinalang.net.grpc.proto.definition.Message;
import org.ballerinalang.net.grpc.proto.definition.Service;
import org.ballerinalang.net.grpc.proto.definition.UserDefinedEnumMessage;

public class File {
    private DescriptorProtos.FileDescriptorProto fileDescriptorProto;
    private List<Message> messageList = new ArrayList<Message>();
    private List<UserDefinedEnumMessage> enumList = new ArrayList<UserDefinedEnumMessage>();
    private List<Service> serviceList = new ArrayList<Service>();
    private List<String> dependencyList = new ArrayList<String>();

    private File(DescriptorProtos.FileDescriptorProto fileDescriptorProto) {
        this.fileDescriptorProto = fileDescriptorProto;
    }

    void setMessageList(List<Message> messageList) {
        this.messageList = messageList;
    }

    void setEnumList(List<UserDefinedEnumMessage> enumList) {
        this.enumList = enumList;
    }

    void setServiceList(List<Service> serviceList) {
        this.serviceList = serviceList;
    }

    void setDependencyList(List<String> dependencyList) {
        this.dependencyList = dependencyList;
    }

    public static Builder newBuilder(String fileName) {
        return new Builder(fileName);
    }

    public DescriptorProtos.FileDescriptorProto getFileDescriptorProto() {
        return this.fileDescriptorProto;
    }

    public Descriptors.FileDescriptor getFileDescriptor() throws GrpcServerException {
        try {
            return Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)this.fileDescriptorProto, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new GrpcServerException(e);
        }
    }

    public String getFileDefinition() {
        StringBuilder fileDefinition = new StringBuilder();
        fileDefinition.append("syntax = \"").append(this.fileDescriptorProto.getSyntax()).append("\";").append(ServiceProtoConstants.NEW_LINE_CHARACTER);
        if (!"".equals(this.fileDescriptorProto.getPackage())) {
            fileDefinition.append("package ").append(this.fileDescriptorProto.getPackage()).append(";").append(ServiceProtoConstants.NEW_LINE_CHARACTER);
        }
        for (String string : this.dependencyList) {
            fileDefinition.append("import \"").append(string).append("\";").append(ServiceProtoConstants.NEW_LINE_CHARACTER);
        }
        for (Service service : this.serviceList) {
            fileDefinition.append(service.getServiceDefinition());
        }
        for (Message message : this.messageList) {
            fileDefinition.append(message.getMessageDefinition());
        }
        for (UserDefinedEnumMessage userDefinedEnumMessage : this.enumList) {
            fileDefinition.append(userDefinedEnumMessage.getMessageDefinition());
        }
        return fileDefinition.toString();
    }

    public static class Builder {
        private DescriptorProtos.FileDescriptorProto.Builder fileBuilder;
        private List<Message> messageList = new ArrayList<Message>();
        private List<UserDefinedEnumMessage> enumList = new ArrayList<UserDefinedEnumMessage>();
        private List<Service> serviceList = new ArrayList<Service>();
        private List<String> dependencyList = new ArrayList<String>();

        public File build() {
            File file = new File(this.fileBuilder.build());
            file.setMessageList(this.messageList);
            file.setEnumList(this.enumList);
            file.setServiceList(this.serviceList);
            file.setDependencyList(this.dependencyList);
            return file;
        }

        public boolean isEnumExists(String enumId) {
            for (UserDefinedEnumMessage enumMessage : this.enumList) {
                if (!enumMessage.getDescriptorProto().getName().equals(enumId)) continue;
                return true;
            }
            return false;
        }

        public Builder setPackage(String packageName) {
            this.fileBuilder.setPackage(packageName);
            return this;
        }

        public Builder setSyntax(String syntax) {
            this.fileBuilder.setSyntax(syntax);
            return this;
        }

        public Builder setService(Service serviceDefinition) {
            this.fileBuilder.addService(serviceDefinition.getServiceDescriptor());
            this.serviceList.add(serviceDefinition);
            return this;
        }

        public Builder setMessage(Message messageDefinition) {
            this.fileBuilder.addMessageType((DescriptorProtos.DescriptorProto)messageDefinition.getDescriptorProto());
            this.messageList.add(messageDefinition);
            return this;
        }

        public Builder setEnum(UserDefinedEnumMessage enumDefinition) {
            this.fileBuilder.addEnumType(enumDefinition.getDescriptorProto());
            this.enumList.add(enumDefinition);
            return this;
        }

        public void setDependency(String dependency) {
            this.fileBuilder.addDependency(dependency);
            this.dependencyList.add(dependency);
        }

        public List<DescriptorProtos.DescriptorProto> getRegisteredMessages() {
            return Collections.unmodifiableList(this.fileBuilder.getMessageTypeList());
        }

        public List<String> getRegisteredDependencies() {
            return Collections.unmodifiableList(this.fileBuilder.getDependencyList());
        }

        public List<DescriptorProtos.EnumDescriptorProto> getRegisteredEnums() {
            return Collections.unmodifiableList(this.fileBuilder.getEnumTypeList());
        }

        private Builder(String fileName) {
            this.fileBuilder = DescriptorProtos.FileDescriptorProto.newBuilder();
            this.fileBuilder.setName(fileName);
        }
    }
}

