/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.calleraction;

import io.grpc.Context;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="sendError", receiver=@Receiver(type=TypeKind.STRUCT, structType="CallerAction", structPackage="ballerina.grpc"), args={@Argument(name="statusCode", type=TypeKind.INT), @Argument(name="message", type=TypeKind.STRING), @Argument(name="headers", type=TypeKind.STRUCT, structType="Headers", structPackage="ballerina.grpc")}, returnType={@ReturnType(type=TypeKind.STRUCT, structType="error", structPackage="ballerina.builtin")}, isPublic=true)
public class SendError
extends BlockingNativeCallableUnit {
    private static final Logger LOG = LoggerFactory.getLogger(SendError.class);
    private static final int MESSAGE_HEADER_REF_INDEX = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(org.ballerinalang.bre.Context context) {
        BStruct endpointClient = (BStruct)context.getRefArgument(0);
        BValue headerValues = context.getNullableRefArgument(1);
        long statusCode = context.getIntArgument(0);
        String errorMsg = context.getStringArgument(0);
        Context msgContext = MessageUtils.getContextHeader(headerValues);
        StreamObserver<Message> responseObserver = MessageUtils.getResponseObserver((BRefType)endpointClient);
        if (responseObserver == null) {
            context.setError(MessageUtils.getConnectorError(context, (Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.INTERNAL.getCode()).withDescription("Error while sending the error. Response observer not found."))));
        } else {
            Context previous = msgContext != null ? msgContext.attach() : null;
            try {
                responseObserver.onError((Throwable)new StatusRuntimeException(Status.fromCodeValue((int)((int)statusCode)).withDescription(errorMsg)));
            }
            finally {
                if (previous != null) {
                    msgContext.detach(previous);
                }
            }
        }
    }
}

