/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.client;

import com.google.protobuf.Descriptors;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="send", receiver=@Receiver(type=TypeKind.STRUCT, structType="GrpcClient", structPackage="ballerina.grpc"), args={@Argument(name="res", type=TypeKind.ANY)}, returnType={@ReturnType(type=TypeKind.STRUCT, structType="error", structPackage="ballerina.builtin")}, isPublic=true)
public class Send
extends BlockingNativeCallableUnit {
    private static final Logger LOG = LoggerFactory.getLogger(Send.class);

    public void execute(Context context) {
        BStruct connectionStruct = (BStruct)context.getRefArgument(0);
        BValue responseValue = context.getRefArgument(1);
        StreamObserver requestSender = (StreamObserver)connectionStruct.getNativeData("REQUEST_SENDER");
        if (requestSender == null) {
            context.setError(MessageUtils.getConnectorError(context, (Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.INTERNAL.getCode()).withDescription("Error while initializing connector. response sender does not exist"))));
        } else {
            Descriptors.Descriptor inputType = (Descriptors.Descriptor)connectionStruct.getNativeData("REQUEST_DEFINITION");
            try {
                Message requestMessage = MessageUtils.generateProtoMessage(responseValue, inputType);
                requestSender.onNext((Object)requestMessage);
            }
            catch (Throwable e) {
                LOG.error("Error while sending client response.", e);
                context.setError(MessageUtils.getConnectorError(context, e));
            }
        }
    }
}

